<?php
$types = get_terms(['taxonomy' => 'type', 'hide_empty' => false, 'number' => 3]);
$path = get_template_directory() . '/dist/images/MT_Logo_Black.svg';
$file = file_get_contents($path);
$file = str_replace(
    '<?xml version="1.0" encoding="UTF-8"?>',
    '',
    $file
);
?>

<header class="l-header">
    <div class="l-header__contain contain">
        <div class="l-header__custom-theme-switcher">
            <?php if(isset($_COOKIE['theme']) && $_COOKIE['theme'] == 'dark') { ?>
                <span class="fas fa-sun" id="theme-svg"></span>
            <?php } else { ?>
                <span class="fas fa-moon" id="theme-svg"></span>
            <?php } ?>
        </div>

        <div class="l-header__center-holder">
            <div class="center-wrapper">
                <a class="navbar-brand" href="<?= esc_url(home_url('/')); ?>">
                    <?php
                    echo str_replace(
                        '<svg',
                        '<svg class="l-header__logo" role="img" aria-label="Model Team"',
                        $file
                    );
                    ?>
                </a>
                <ul>
                    <li class="fw-700 u-case">
                        <a href="" class="female-menu-link main-nav-link">Female</a>
                        <ul class="custom-sub-menu">
                            <div class="contain">
                                <?php foreach($types as $type) {
                                    $femaleTypeImage = get_field('female_featured_image', 'type_' . $type->term_id);
                                    $image = wp_get_attachment_image_src( $femaleTypeImage['id'], 'model-menu-type' );
                                    ?>
                                    <li>
                                        <a href="<?= get_category_link($type->term_id) . '?g=female' ?>">
                                            <div class="image-wrapper">
                                                <img src="<?= $image[0]; ?>" alt="<?= $femaleTypeImage['alt']; ?>" loading="lazy">
                                            </div>
                                            <div class="title u-case"><?= $type->name; ?></div>
                                        </a>
                                    </li>
                                <?php } ?>
                            </div>
                        </ul>
                    </li>
                    <li class="fw-700 u-case">
                        <a href="" class="male-menu-link main-nav-link">Male</a>
                        <ul class="custom-sub-menu">
                            <div class="contain">
                                <?php foreach($types as $type) {
                                    $maleTypeImage = get_field('male_featured_image', 'type_' . $type->term_id);
                                    $image = wp_get_attachment_image_src( $maleTypeImage['id'], 'model-menu-type' );
                                    ?>
                                    <li>
                                        <a href="<?= get_category_link($type->term_id) . '?g=male' ?>">
                                            <div class="image-wrapper">
                                                <img src="<?= $image[0]; ?>" alt="<?= $maleTypeImage['alt']; ?>" loading="lazy">
                                            </div>
                                            <div class="title u-case"><?= $type->name; ?></div>
                                        </a>
                                    </li>
                                <?php } ?>
                            </div>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>

        <div class="navigation-toggle">
            <button class="navigation-toggle__hamburger" aria-label="Open Navigation"><span class="far fa-bars hamburger-icon"></span></button>
        </div>

    </div>

    <div class="menu-overlay">
        <div class="menu-overlay__contain contain">
            <div class="top">
                <div class="l-header__custom-theme-switcher">
                    <?php if(isset($_COOKIE['theme']) && $_COOKIE['theme'] == 'dark') { ?>
                        <span class="fas fa-sun" id="theme-svg"></span>
                    <?php } else { ?>
                        <span class="fas fa-moon" id="theme-svg"></span>
                    <?php } ?>
                </div>
                <a class="navbar-brand" href="<?= esc_url(home_url('/')); ?>">
                    <?php
                    echo str_replace(
                        '<svg',
                        '<svg class="l-header__logo" role="img" aria-label="Model Team"',
                        $file
                    );
                    ?>
                </a>
                <div class="navigation-toggle">
                    <button class="navigation-toggle__close" aria-label="Close Navigation"><span class="far fa-times close-icon"></span></button>
                </div>
            </div>
            <div class="middle u-case fw-700">
                <?php
                if (has_nav_menu('main_menu')) {
                    wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'main-navigation']);
                }
                ?>
            </div>
            <div class="bottom u-case fw-700">
                <?php
                if (has_nav_menu('footer_menu')) {
                    wp_nav_menu(['theme_location' => 'footer_menu', 'menu_class' => 'footer-navigation']);
                }
                ?>
            </div>
        </div>
    </div>
</header>
