<?php
$gallery = get_field('gallery');
$social = get_field('instagram_handle');
?>

<div class="custom-model-single">
    <?php
    $bannerImage = get_field('banner_image');
    $image = wp_get_attachment_image_src($bannerImage['id'], 'banner-image');
    if($bannerImage) {?>
        <div class="custom-flexible-section hero-section">
            <img src="<?= $image[0]; ?>" alt="<?php the_title(); ?>">
            <div class="name u-case fw-700"><div class="contain"><?php the_title(); ?></div></div>
        </div>
    <?php } ?>

    <nav>
        <div class="contain">
            <ul class="u-case fw-700">
                <li><a href="#info">Info</a></li>
                <?php if($gallery) { ?><li><a href="#portfolio">Portfolio</a></li><?php } ?>
                <?php if($social) { ?><li><a href="#social">Social</a></li><?php } ?>
            </ul>
        </div>
    </nav>

    <main>
        <section class="info-section" id="info">
            <div class="contain">
                <div class="info-wrapper">
                    <div class="primary-content">
                        <h1 class="u-case fw-700"><?= preg_replace('([a-zA-Z.,!?0-9]+(?![^<]*>))', '<span>$0</span>', get_the_title()); ?></h1>
                        <div class="table-wrapper">
                            <table class="stats">
                                <tbody>
                                <tr>
                                    <td>Height</td>
                                    <td><?php the_field('height'); ?></td>
                                </tr>
                                <tr>
                                    <td>Hair</td>
                                    <td><?php the_field('hair'); ?></td>
                                </tr>
                                <tr>
                                    <td>Eyes</td>
                                    <td><?php the_field('eyes'); ?></td>
                                </tr>
                                <tr>
                                    <td>Bust</td>
                                    <td><?php the_field('bust'); ?></td>
                                </tr>
                                <tr>
                                    <td>Dress</td>
                                    <td><?php the_field('dress'); ?></td>
                                </tr>
                                <tr>
                                    <td>Waist</td>
                                    <td><?php the_field('waist'); ?></td>
                                </tr>
                                <tr>
                                    <td>Hips</td>
                                    <td><?php the_field('hips'); ?></td>
                                </tr>
                                <tr>
                                    <td>Shoes</td>
                                    <td><?php the_field('shoes'); ?></td>
                                </tr>
                                </tbody>

                            </table>
                        </div>
                    </div>
                    <div class="secondary-content">
                        <?php if(get_the_post_thumbnail_url()) { ?>
                            <div class="image-wrapper">
                                <img src="<?php the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </section>

        <?php if($gallery) { ?>
            <section class="portfolio-section" id="portfolio">
                <div class="contain">
                    <button class="toggle-type u-case fw-700"><span class="fas fa-th-large"></span> See <span class="number">2</span></button>
                    <div class="grid image-output">
                        <?php foreach($gallery as $image) { ?>
                            <div class="item">
                                <img src="<?= $image['gallery_image']['url']; ?>" alt="<?= $image['gallery_image']['alt']; ?>" loading="lazy">
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </section>
        <?php } ?>



        <?php if($social) { ?>
            <section class="social-section" id="social">

            </section>
        <?php } ?>
    </main>
</div>
