import { fontawesome, throttle } from './utils';
import Swiper from 'swiper';

const common = () => {
    fontawesome();
    const currentTheme = localStorage.getItem('theme') ? localStorage.getItem('theme') : null;
    const themeSwitcher = $('.l-header__custom-theme-switcher');

    if (currentTheme) {
        document.documentElement.setAttribute('data-theme', currentTheme);
    }

    $(themeSwitcher).on('click', function() {
        const icon = $(themeSwitcher).find('svg');
        const iconFaIcon = icon.attr('data-icon');
        if (document.documentElement.getAttribute('data-theme') === 'dark') {
            iconFaIcon === 'moon' ? icon.attr('data-icon', 'sun') : icon.attr('data-icon', 'moon');
            document.documentElement.setAttribute('data-theme', 'light');
            localStorage.setItem('theme', 'light');
            document.cookie = 'theme=light';
        } else {
            iconFaIcon === 'sun' ? icon.attr('data-icon', 'moon') : icon.attr('data-icon', 'sun');
            document.documentElement.setAttribute('data-theme', 'dark');
            localStorage.setItem('theme', 'dark');
            document.cookie = 'theme=dark';
        }
    });

    $('.main-nav-link').on('click', function(e) {
        e.preventDefault();
    });

    $('.navigation-toggle button').on('click', function() {
        $('.menu-overlay').toggleClass('active');
    });

    if ($('.block-slider').length) {
        new Swiper('.swiper-container', {
            loop: true,
            lazy: true,
            pagination: {
                el: '.swiper-pagination',
                type: 'bullets',
                clickable: true,
            },
            breakpoints: {
                0: {
                    slidesPerView: 1,
                    spaceBetween: 32
                },
                512: {
                    slidesPerView: 2,
                    spaceBetween: 32
                },
                992: {
                    spaceBetween: 32,
                    slidesPerView: 3,
                }
            },
        });
    }
};

export default common;
