<?php
$types = get_terms(['taxonomy' => 'type', 'hide_empty' => false]);
$gender = isset($_GET['g']) ? $_GET['g'] : "";
$queriedObject = get_queried_object();
?>

<main class="custom-taxonomy-gender">
    <?php
    $term = get_queried_object();
    $flexibleFieldName = $gender . '_flexible_sections';
    if(get_field($flexibleFieldName, 'option')) { ?>
        <div class="flexible-layout">
            <?php Blue2\Scruffy\Utils::optionsflexibleLoop('flexible_sections', $gender); ?>
        </div>
    <?php } ?>

    <?php if($types) { ?>
        <nav class="type-navigation">
            <div class="contain">
                <ul class="u-case fw-700" id="accordion-list">
                    <div class="toggle-holder"><span class="accordion-toggle fal fa-chevron-down"></span></div>
                    <?php foreach($types as $type) { ?>
                        <li class="<?= $queriedObject->slug == $type->slug ? 'active' : "inactive"; ?>"><a href="<?= get_category_link($type->term_id); ?>"><?= $type->name; ?></a></li>
                    <?php } ?>
                </ul>
            </div>
        </nav>
    <?php } ?>

    <?php

    $typeArgs = [
        'post_type' => 'model',
        'posts_per_page' => -1,
        'post_status' => 'publish',
        'order' => 'ASC',
        'orderby' => 'title',
        'tax_query' => [
            'relation' => 'AND',
            [
                'taxonomy' => 'gender',
                'terms' => $gender,
                'field' => 'slug'
            ],
            [
                'taxonomy' => 'type',
                'terms' => $queriedObject->slug,
                'field' => 'slug'
            ]
        ]
    ];

    $typeQuery = new WP_Query($typeArgs);

    if($typeQuery->have_posts()) { ?>
        <div class="model-list">
            <div class="contain">
                <div class="model-grid">
                    <?php while($typeQuery->have_posts()){
                        $typeQuery->the_post();
                        $image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'model-archive-image');
                        ?>
                        <div class="model-item">
                            <a href="<?php the_permalink(); ?>">
                                <div class="image-wrapper">
                                    <img src="<?= $image[0]; ?>" alt="<?php the_title(); ?>">
                                </div>
                                <div class="content-wrapper">
                                    <h3 class="u-case fw-700"><?= preg_replace('([a-zA-Z.,!?0-9]+(?![^<]*>))', '<span>$0</span>', get_the_title()); ?></h3>
                                </div>
                            </a>
                        </div>
                    <?php } wp_reset_postdata(); ?>
                </div>
            </div>
        </div>
    <?php } ?>

</main>


