<?php
$blocksTitle = get_sub_field('blocks_title');
$blockShape = get_sub_field('block_shape');
$blocks = get_sub_field('blocks');
if($blocks) { ?>
    <div class="custom-flexible-section block-slider">

        <div class="contain">
            <?php if($blocksTitle) { ?><h2 class="fw-700 u-case text-right"><?= $blocksTitle ?></h2><?php } ?>
        </div>

        <div class="block-slider__contain contain">
            <div class="swiper-container swiper-block-slider">
                <div class="swiper-wrapper">
                    <?php foreach($blocks as $block) {
                        $imageSize = $blockShape == 'square' ? 'large-square-image' : 'rectangle-image';
                        $image = wp_get_attachment_image_src($block['image']['id'], $imageSize);
                        ?>
                        <div class="swiper-slide">
                            <div class="block-slide">
                                <a href="<?= $block['link']['url']; ?>">
                                    <div class="image-wrapper <?= $blockShape; ?>">
                                        <img src="<?= $image[0]; ?>" alt="<?= $block['image']['alt'] ?>" class="swiper-lazy">
                                        <div class="swiper-lazy-preloader swiper-lazy-preloader-white"></div>
                                    </div>
                                    <?php if($block['title'] || $block['subtitle']) { ?>
                                        <div class="content-wrapper">
                                            <?php if($block['title']) { ?><h3 class="u-case fw-700"><?= $block['title']; ?></h3><?php } ?>
                                            <?php if($block['subtitle']) { ?><h4><?= $block['subtitle']; ?></h4><?php } ?>
                                        </div>
                                    <?php } ?>
                                </a>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <div class="swiper-pagination"></div>
            </div>

        </div>
    </div>
<?php } ?>
