<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\ModelController;

class Site extends \Blue2\Common\Site
{
    public function __construct() {
        parent::__construct();

        add_theme_support('post-thumbnails');
        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus() {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu'
        ]);
    }

    public function tidyExcerpt() {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    private function registerShortCodes() {
        // Empty
    }

    private function registerFilters() {
        add_filter('walker_nav_menu_start_el', [$this, 'addChevronToMenuItemsWithChildren'], 10, 4 );
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('init', [$this, 'customImageSizes']);
    }

    private function setupControllers() {
        new ModelController();
    }

    public function registerPostTypes(){
        Post\Model::registerPostType();
    }

    public function customImageSizes()
    {
        add_image_size('model-menu-type', 760, 570, true);
    }

    public function addChevronToMenuItemsWithChildren( $item_output, $item, $depth, $args ) {
        if ( $args->theme_location == 'main_menu' && $args->menu_class == 'main-navigation') {
            if ( in_array( 'menu-item-has-children', $item->classes ) || in_array( 'page_item_has_children', $item->classes ) ) {
                $item_output = str_replace( $args->link_after . '</a>', $args->link_after . '<span class="fal fa-chevron-down" class="menu-svg"></span>', $item_output );
            }
        }
        return $item_output;
    }

}
