<?php

namespace Blue2\Common\Theme;

class Utils
{
    public static function simpleWrappedLoop($contentSlug = "", $headerName = "", $footerName = "")
    {
        get_header($headerName);
        self::simpleLoop($contentSlug);
        get_footer($footerName);
    }

    public static function simpleWrapped($templateSlug = "", $headerName = "", $footerName = "")
    {
        get_header($headerName);
        locate_template('templates/' . $templateSlug . '.php', true);
        get_footer($footerName);
    }

    public static function archiveWrapped($headerName = "", $footerName = "")
    {
        if (!get_post_type()) {
            global $wp_query;
            $postType = $wp_query->query['post_type'];
        } else {
            $postType = get_post_type();
        }

        get_header($headerName);
        locate_template('templates/' . $postType . '/archive.php', true);
        get_footer($footerName);
    }

    public static function archiveLoop()
    {
        if (have_posts()) {
            $checkFeatured = true;
            while (have_posts()) {
                the_post();
                if ($checkFeatured) {
                    $templates = [
                        'templates/' . get_post_type() . '/content-featured.php',
                        'templates/' . get_post_type() . '/content.php'
                    ];
                    locate_template($templates, true);
                    $checkFeatured = false;
                } else {
                    get_template_part('templates/' . get_post_type() . '/content');
                }
            }
        } else {
            get_template_part('templates/content', 'none');
        }
    }

    public static function simpleLoop($contentSlug = "")
    {
        if (have_posts()) {
            while (have_posts()) {
                the_post();
                self::includeContentTemplate($contentSlug);
            }
        } else {
            get_template_part('templates/content', 'none');
        }
    }

    public static function includeContentTemplate($contentSlug = "")
    {
        $post = get_post();

        $templates = array(
            'templates/content-' . $contentSlug . '.php',
            'templates/content-' . $post->post_name . '.php',
            'templates/' . get_post_type() . '/single.php',
            'templates/' . get_post_type() . '/content.php',
            'templates/content-' . get_post_format() . '.php',
            'templates/content.php'
        );

        locate_template($templates, true);
    }

    /**
     * Loop over flexible field and output the correct template for each row
     *
     * @param string $fieldName
     * @return void
     */
    public static function flexibleLoop($fieldName = "sections")
    {
        if (have_rows($fieldName)) {
            while (have_rows($fieldName)) {
                the_row();
                get_template_part('templates/' . $fieldName . '/' . get_row_layout());
            }
        }
    }

    public static function getTitle($prefix = "", $suffix = "")
    {
        $title = get_the_title();

        if (is_home()) {
            if (get_option('page_for_posts', true)) {
                $title = get_the_title(get_option('page_for_posts', true));
            } else {
                // it's a blog home page
                $title = 'Latest Posts';
            }
        } elseif (is_archive()) {
            $title = get_the_archive_title();
        } elseif (is_search()) {
            $title = sprintf('Search Results for %s', get_search_query());
        } elseif (is_404()) {
            $title = 'Not Found';
        }

        return $prefix . $title . $suffix;
    }
}
