<?php

namespace Blue2\Common;


class Taxonomy
{
    public function __construct($slug, $singular, $plural, $postTypes = null, $labels = [], $args = [])
    {
        $labels = array_merge($this->defaultRegisterLabels($singular, $plural), $labels);
        $args = array_merge($this->defaultRegisterArgs(), $args);
        $args['labels'] = $labels;

        register_taxonomy($slug, $postTypes, $args);
    }

    private function defaultRegisterLabels($singular, $plural)
    {
        return [
            'name' => _x($plural, 'Taxonomy General Name', 'text_domain'),
            'singular_name' => _x($singular, 'Taxonomy Singular Name', 'text_domain'),
            'menu_name' => __($plural, 'text_domain'),
            'all_items' => __('All ' . $plural, 'text_domain'),
            'parent_item' => __('Parent ' . $singular, 'text_domain'),
            'parent_item_colon' => __("Parent {$singular}:", 'text_domain'),
            'new_item_name' => __("New {$singular} Name", 'text_domain'),
            'add_new_item' => __('Add New ' . $singular, 'text_domain'),
            'edit_item' => __('Edit ' . $singular, 'text_domain'),
            'update_item' => __('Update ' . $singular, 'text_domain'),
            'view_item' => __('View ' . $singular, 'text_domain'),
            'separate_items_with_commas' => __('Separate ' . $plural . ' with commas', 'text_domain'),
            'add_or_remove_items' => __('Add or remove ' . $plural, 'text_domain'),
            'choose_from_most_used' => __('Choose from the most used', 'text_domain'),
            'popular_items' => __('Popular ' . $plural, 'text_domain'),
            'search_items' => __('Search ' . $plural, 'text_domain'),
            'not_found' => __('Not Found', 'text_domain'),
            'no_terms' => __('No ' . $plural, 'text_domain'),
            'items_list' => __('Items list', 'text_domain'),
            'items_list_navigation' => __('Items list navigation', 'text_domain'),
        ];
    }

    private function defaultRegisterArgs()
    {
        return [
            'hierarchical' => true,
            'public' => true,
            'show_ui' => true,
            'show_admin_column' => true,
            'show_in_nav_menus' => true,
            'show_tagcloud' => true,
            "show_in_rest" => true, // Must be enabled for Gutenberg support
        ];
    }
}
