<?php


namespace Blue2\Common\Site;


class StandardMeta
{
    public function __construct()
    {
        add_action('wp_head', [$this, 'addCompanyMeta']);
    }

    public function addCompanyMeta()
    {
        if($brandColour = get_field('brand_colour', 'option')) {
            echo '<meta name="apple-mobile-web-app-capable" content="yes">';
            echo '<meta name="theme-color" content="'. $brandColour .'">';
            echo '<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">';
        }

        $meta = [
            '@context' => 'http://schema.org',
            '@type' => 'LocalBusiness',
            'url' => home_url()
        ];

        if (get_field('company_name', 'option')) {
            $meta['name'] = get_field('company_name', 'option');
        }

        if (get_field('contact_phone_number', 'option')) {
            $meta['telephone'] = get_field('contact_phone_number', 'option');
        }

        if (get_field('contact_email_address', 'option')) {
            $meta['email'] = get_field('contact_email_address', 'option');
        }

        if (get_field('company_location', 'option')) {
            $location = get_field('company_location', 'option');
            $meta['address'] = $location['address'];

            $meta['geo'] = [
                '@type' => 'GeoCoordinates',
                'latitude' => $location['lat'],
                'longitude' => $location['lng']
            ];
        }

        if (get_field('company_logo', 'option')) {
            $logoObj = get_field('company_logo', 'option');
            $logoURL = substr($logoObj['url'], 0, 4) == 'http' ? $logoObj['url'] : home_url($logoObj['url']);
            $meta['logo'] = $logoURL;
        }

        if (have_rows('social_media_channels', 'option')) {
            $meta['sameAs'] = [];
            while (have_rows('social_media_channels', 'option')) {
                the_row();
                $meta['sameAs'][] = get_sub_field('full_url');
            }
        }

        if(has_post_thumbnail()) {
            $meta['image'] = get_the_post_thumbnail_url();
        } else if (get_field('company_logo', 'option')) {
            $logoObj = get_field('company_logo', 'option');
            $logoURL = substr($logoObj['url'], 0, 4) == 'http' ? $logoObj['url'] : home_url($logoObj['url']);
            $meta['image'] = $logoURL;
        }

        echo '<script type="application/ld+json">';
        echo json_encode($meta);
        echo '</script>';
    }
}
