<?php


namespace Blue2\Common\Site;


class PluginLoader
{
    public function __construct()
    {
        add_action('admin_init', [$this, 'activateRequiredPlugins']);
    }

    public function activateRequiredPlugins()
    {
        $requiredPlugins = [
            "disable-comments/disable-comments",
            "soil/soil",
            "amazon-s3-and-cloudfront/wordpress-s3",
            "advanced-custom-fields-pro/acf",
        ];

        foreach ($requiredPlugins as $requiredPlugin) {
            $path = $requiredPlugin . ".php";
            if (!is_plugin_active($path)) {
                activate_plugin($path);
                add_action('admin_notices', function () use ($requiredPlugin) {
                    sprintf('<div class="updated"><p><strong>%s</strong> plugin is required & auto-enabled by the current theme.</p></div>', $requiredPlugin);
                });
            }
        }
    }
}
