<?php


namespace Blue2\Common\Site;


class ACF
{
    public function __construct()
    {
        add_filter('acf/settings/save_json', [$this, 'acfJsonSaveLocation']);
        add_filter('acf/settings/load_json', [$this, 'acfJsonLoadLocation']);

        // Only allow fields to be edited on development
//        if (!WP_LOCAL_DEV) {
//            add_filter('acf/settings/show_admin', '__return_false');
//        }

        //add_action('admin_init', [$this, 'syncAcfJsonFields']);
        add_action('wp_loaded', [$this, 'addThemeSettingsPage']);
    }

    public function acfJsonSaveLocation()
    {
        $path = get_stylesheet_directory() . '/acf-json';
        return $path;
    }

    public function acfJsonLoadLocation($paths)
    {
        unset($paths[0]);
        $paths[] = get_stylesheet_directory() . '/acf-json';
        return $paths;
    }

    public function syncAcfJsonFields()
    {
        // Source : https://deliciousbrains.com/advanced-custom-fields-wordpress/

        if (defined('DOING_AJAX') || defined('DOING_CRON')) {
            return;
        }

        if (!function_exists('acf_get_field_groups')) {
            return;
        }

        $groups = acf_get_field_groups();

        if (empty($groups)) {
            return;
        }

        $sync = [];

        foreach ($groups as $group) {
            $local = acf_maybe_get($group, 'local', false);
            $modified = acf_maybe_get($group, 'modified', 0);
            $private = acf_maybe_get($group, 'private', false);

            if ($local !== 'json' || $private) {
                // Ignore DB / PHP / private field groups
                continue;
            }

            if (!$group['ID']) {
                $sync[$group['key']] = $group;
            } elseif ($modified && $modified > get_post_modified_time('U', true, $group['ID'], true)) {
                $sync[$group['key']] = $group;
            }
        }

        if (empty($sync)) {
            return;
        }

        foreach ($sync as $key => $v) {
            if (acf_have_local_fields($key)) {
                $sync[$key]['fields'] = acf_get_local_fields($key);
            }
            acf_import_field_group($sync[$key]);
        }
    }

    public function addThemeSettingsPage()
    {
        if (function_exists('acf_add_options_page')) {
            acf_add_options_page([
                'page_title' => 'Theme Settings',
                'capability' => 'edit_posts'
            ]);
        }
    }
}
