<?php
$types = get_terms(['taxonomy' => 'type', 'hide_empty' => false]);
$gender = isset($_GET['g']) ? $_GET['g'] : "";
$queriedObject = get_queried_object();
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
?>

<main class="custom-taxonomy-gender">


    <div class="holder d-flex">
        <?php
        $term = get_queried_object();
        $flexibleFieldName = $gender . '_flexible_sections';
        if(get_field($flexibleFieldName, 'option')) { ?>
            <div class="order-2 order-lg-1 flexible-layout">
                <?php Blue2\Scruffy\Utils::optionsflexibleLoop('flexible_sections', $gender); ?>
            </div>
        <?php } ?>

        <?php if($types) { ?>
            <nav class="order-1 order-lg-2 type-navigation">
                <div class="contain">
                    <ul class="u-case fw-700" id="accordion-list">
                        <div class="toggle-holder"><span class="accordion-toggle fal fa-chevron-down"></span></div>
                        <?php foreach($types as $type) { ?>
                            <li class="<?= $type->slug; ?> <?= $queriedObject->slug == $type->slug ? 'active order-1' : "order-2 inactive"; ?>"><a href="<?= get_category_link($type->term_id) . '?g=' . $gender; ?>"><?= $type->name; ?></a></li>
                        <?php } ?>
                    </ul>
                </div>
            </nav>
        <?php } ?>
    </div>

    <?php
    $typeArgs = [
        'post_type' => 'model',
        'posts_per_page' => -1,
        'post_status' => 'publish',
        'order' => 'ASC',
        'orderby' => 'title',
        'tax_query' => [
            'relation' => 'AND',
            [
                'taxonomy' => 'gender',
                'terms' => $gender,
                'field' => 'slug'
            ],
            [
                'taxonomy' => 'type',
                'terms' => $queriedObject->slug,
                'field' => 'slug'
            ]
        ]
    ];

    $typeQuery = new WP_Query($typeArgs);

    if($typeQuery->have_posts()) { ?>
        <div class="model-list">
            <div class="contain">
                <div class="model-grid">
                    <?php while($typeQuery->have_posts()){
                        $typeQuery->the_post();

                        if(get_post_thumbnail_id()){
                            $imgID = get_post_thumbnail_id();
                            $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
                            $imageDetails = wp_get_attachment_image_src($imgID, 'model-archive-image');
                            $image = '<img src=" ' . $imageDetails[0] . '" alt="'. $imageAlt .'" loading="lazy">';
                            $imageClass = 'featured-image';
                        } else {
                            $image = $defaultImage;
                            $imageClass = 'default-image';
                        }
                        $nameString = explode(' ', get_the_title());
                        ?>
                        <div class="model-item">
                            <a href="<?php the_permalink(); ?>">
                                <div class="image-wrapper <?= $imageClass; ?>">
                                    <?= $image; ?>
                                </div>
                                <div class="content-wrapper">
                                    <h3 class="u-case fw-700"><?= implode($nameString, '<br/>' ); ?></h3>
                                </div>
                            </a>
                        </div>
                    <?php } wp_reset_postdata(); ?>
                </div>
            </div>
        </div>
    <?php } ?>

</main>


