<?php

namespace Blue2\Scruffy\Controllers;

use Instagram\Instagram;
use EspressoDev\InstagramBasicDisplay\InstagramBasicDisplay;

class InstagramController
{
    const clientID = '305150128285593';
    const clientSecret = '7f5416d534c0e17ce83bcf0de306bb43';
    

    public function __construct()
    {
        $redirectURI = 'https://' . $_SERVER['HTTP_HOST'] . '/wp-json/modelteam/v1/oauth-callback';
        $this->instagram = new InstagramBasicDisplay([
            'appId'         => self::clientID,
            'appSecret'     => self::clientSecret,
            'redirectUri'   => $redirectURI]);

        add_action('wp_dashboard_setup', [$this, 'addInstaWidget']);

        add_action('rest_api_init', function () {
            register_rest_route('modelteam/v1', '/get-insta-feed/', [
                'methods' => 'GET',
                'callback' => [$this, 'getFeed'],
                'permission_callback' => '__return_true'
            ]);
        });
        add_action('rest_api_init', function () {
            register_rest_route('modelteam/v1', '/insta-authentication/', [
                'methods' => 'GET',
                'callback' => [$this, 'getInstaAuthorization'],
                'permission_callback' => '__return_true'
            ]);
        });
        add_action('rest_api_init', function () {
            register_rest_route('modelteam/v1', '/oauth-callback/', [
                'methods' => 'GET',
                'callback' => [$this, 'instaOAuthCallback'],
                'permission_callback' => '__return_true'
            ]);
        });
        add_action('admin_notices', [$this, 'general_admin_notice']);
    }

    public function addInstaWidget()
    {
        global $wp_meta_boxes;
        if (current_user_can('administrator')) {
            wp_add_dashboard_widget('addInstaWidgetOAuth', 'Instagram Authentication', [$this, 'InstaOAuthForm']);
        }
    }

    public function InstaOAuthForm() { ?>
        <form action="/wp-json/modelteam/v1/insta-authentication" method="GET" name="instaOAuth">
            <p>Renew the authorization with Instagram. Don't touch until is necessary.</p>
            <input class="button button-primary " type="submit" name="instaAuth" value="Renew Instagram Authentication">
        </form>
      <?php
    }

    public function getInstaAuthorization()
    {
        $authURL = $this->instagram->getLoginUrl();
        header("Location: {$authURL}");
        exit();
    }

    public function general_admin_notice()
    {
        if (isset($_GET['instagram']) && $_GET['instagram'] == 'success') {
            echo '<div class="notice notice-success is-dismissible">
                <p>Instagram authorization complete!</p>
            </div>';
        }
    }

    public function instaOAuthCallback()
    {
        if (isset($_GET['code'])) {
            $code = $_GET['code'];
            $token = $this->instagram->getOAuthToken($code);
            $token = $this->instagram->getLongLivedToken($token->access_token, true);
            
            $expire = strtotime(date('Y-m-d H:m:s', strtotime("+60 days")));
            update_field('instagram_token', $token, 'options');
            update_field('instagram_timestamp', $expire, 'options');
            wp_redirect(admin_url('') . '?instagram=success');
            
            exit;
        }
    }

    private function refreshToken()
    {
        $token = get_field('instagram_token', 'options');
        $expire = get_field('instagram_timestamp', 'options');
        $currTime = strtotime('now');

        if ($token && $currTime > $expire) {
            $newToken = $this->instagram->refreshToken($token, true);
            $newExpire = date('Y-m-d H:m:s', strtotime("+60 days"));
            update_field('instagram_token', $newToken, 'options');
            update_field('instagram_timestamp', $newExpire, 'options');
        }
    }

    private static function getToken()
    {
        return get_field('instagram_token', 'options');
    }

    public function getFeed()
    {
        try {
            self::refreshToken();
        
            $this->instagram->setAccessToken(self::getToken());
            $profile = $this->instagram->getUserProfile();
            $media = $this->instagram->getUserMedia($profile->id, 12);
            return $media;
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }
}
