import { fontawesome, throttle } from './utils';

const common = () => {
    fontawesome();
    const currentTheme = localStorage.getItem('theme') ? localStorage.getItem('theme') : null;
    const themeSwitcher = $('.custom-theme-switcher');

    if (currentTheme) {
        document.documentElement.setAttribute('data-theme', currentTheme);
    }

    $(themeSwitcher).on('click', function() {
        const icon = $(themeSwitcher).find('svg');
        const iconFaIcon = icon.attr('data-icon');
        if (document.documentElement.getAttribute('data-theme') === 'dark') {
            iconFaIcon === 'moon' ? icon.attr('data-icon', 'sun') : icon.attr('data-icon', 'moon');
            document.documentElement.setAttribute('data-theme', 'light');
            localStorage.setItem('theme', 'light');
            document.cookie = 'theme=light';
        } else {
            iconFaIcon === 'sun' ? icon.attr('data-icon', 'moon') : icon.attr('data-icon', 'sun');
            document.documentElement.setAttribute('data-theme', 'dark');
            localStorage.setItem('theme', 'dark');
            document.cookie = 'theme=dark';
        }
    });
};

export default common;
