import Swiper from 'swiper';

const model = () => {
    $('.toggle-type').on('click', function() {
        const container = $('.image-output');
        const number =  $(this).find('.number');
        number.text((i, t) => t === '2' ? '4' : '2');
        container.toggleClass('grid masonry');
    });

    $('.custom-model-single nav ul li a[href*=\\#]').on('click', function(event) {
        event.preventDefault();
        $('html,body').animate({ scrollTop:$(this.hash).offset().top - 25 }, 500);
    });

    $('.stat-toggle li').on('click', function(e) {
        e.preventDefault();
        const measurement = $(this).attr('data-measurement');
        $('.stat-toggle li').removeClass('active');
        $(this).addClass('active');
        $('table.stats td span').hide();
        $(`table.stats td span.${measurement}`).show();
    });

    $('.toggle li').on('click', function(e) {
        e.preventDefault();
        const measurement = $(this).attr('data-measurement');
        $('.toggle li').removeClass('active');
        $(this).addClass('active');
        $('.stats-overlay li span').hide();
        $(`.stats-overlay li span.${measurement}`).show();
    });

    if ($('.model-show-swiper').length) {
        new Swiper('.model-show-swiper', {
            loop: true,
            lazy: true,
            pagination: {
                el: '.swiper-pagination',
                type: 'bullets',
                clickable: true,
            },
            breakpoints: {
                0: {
                    slidesPerView: 1,
                    spaceBetween: 32
                },
                512: {
                    slidesPerView: 2,
                    spaceBetween: 32
                },
                992: {
                    spaceBetween: 32,
                    slidesPerView: 3,
                }
            },
        });
    }
};

export default model;
