<?php

$galleryItems = get_sub_field('gallery_items');

if($galleryItems) { ?>
    <div class="custom-flexible-section gallery-section">
        <div class="contain">
            <div class="gallery">
                <?php foreach($galleryItems as $item) {

                    $padding = "style='";
                    $paddingTop = $item['padding_top'];
                    $paddingRight = $item['padding_right'];
                    $paddingBottom = $item['padding_bottom'];
                    $paddingLeft = $item['padding_left'];

                    if($paddingTop) {
                        $padding .= "padding-top:" . $paddingTop . 'px; ';
                    }
                    if($paddingRight) {
                        $padding .= "padding-right:" . $paddingRight . 'px; ';
                    }
                    if($paddingBottom) {
                        $padding .= "padding-bottom:" . $paddingBottom . 'px; ';
                    }
                    if($paddingLeft) {
                        $padding .= "padding-left:" . $paddingLeft . 'px;';
                    }
                    $padding .= "'";
                    $image = wp_get_attachment_image_src($item['image']['id'], 'flexible-split-50');
                    ?>
                    <div class="gallery-item" <?= $padding; ?>>
                        <?php if($item['link']) { ?><a href="<?= $item['link']['url']; ?>"><?php } ?>
                            <div class="image-wrapper">
                                <img src="<?= $image[0]; ?>" loading="lazy">
                            </div>
                            <div class="content-wrapper">
                                <?php if($item['primary_text']) { ?><h3 class="u-case fw-700"><?= $item['primary_text']; ?></h3><?php } ?>
                                <?php if($item['secondary_text']) { ?><h4><?= $item['secondary_text']; ?></h4><?php } ?>
                            </div>
                        <?php if($item['link']) { ?></a><?php } ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
