<?php
$blocksTitle = get_sub_field('blocks_title');
$blockShape = get_sub_field('block_shape');
$blocks = get_sub_field('blocks');
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
if($blocks) { ?>
    <div class="custom-flexible-section block-slider">
        <div class="contain">
            <?php if($blocksTitle) { ?><h2 class="fw-700 u-case text-right"><?= $blocksTitle ?></h2><?php } ?>
        </div>

        <div class="block-slider__contain contain">
            <div class="swiper-container swiper-block-slider">
                <div class="swiper-wrapper">
                    <?php foreach($blocks as $block) {

                        $blockType = $block['block_type'];
                        ?>
                        <div class="swiper-slide">
                            <div class="block-slide">
                                <?php if($block['link']) { ?><a href="<?= $block['link']['url']; ?>"><?php } ?>

                                    <?php if($blockType == 'video' && $block['video']) { ?>
                                        <div class="video-wrapper <?= $blockShape; ?>">
                                            <video playsinline autoplay muted loop>
                                                <source src="<?= $block['video']['url']; ?>" type="video/mp4">
                                            </video>
                                        </div>
                                    <?php } else {
                                        $imageSize = $blockShape == 'square' ? 'large-square-image' : 'rectangle-image';
                                        $image = wp_get_attachment_image_src($block['image']['id'], $imageSize);
                                        if($block['image']){
                                            $imageDetails = wp_get_attachment_image_src($block['image']['id'], $imageSize);
                                            $image = '<img src=" ' . $imageDetails[0] . '" alt="'. $block['image']['alt'] .'" class="swiper-lazy"><div class="swiper-lazy-preloader swiper-lazy-preloader-white"></div>';
                                            $imageClass = 'featured-image';
                                        } else {
                                            $image = $defaultImage;
                                            $imageClass = 'default-image';
                                        }
                                        ?>
                                        <div class="<?= $imageClass; ?> image-wrapper <?= $blockShape; ?>">
                                            <?= $image; ?>
                                        </div>
                                    <?php }  ?>

                                    <?php if($block['title'] || $block['subtitle']) { ?>
                                        <div class="content-wrapper">
                                            <?php if($block['title']) { ?><h3 class="u-case fw-700"><?= $block['title']; ?></h3><?php } ?>
                                            <?php if($block['subtitle']) { ?><h4><?= $block['subtitle']; ?></h4><?php } ?>
                                        </div>
                                    <?php } ?>
                                <?php if($block['link']) { ?></a><?php } ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </div>
<?php } ?>
