<!DOCTYPE html>
<html <?php language_attributes(); ?> data-theme="light">
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <?php
    /**
     * Fonts loaded from Typekit but deferred with high priority
     *
     * @see https://csswizardry.com/2020/05/the-fastest-google-fonts/
     */
    $font_url = 'https://use.typekit.net/znp6zuv.css';
    ?>
    <link rel="preconnect" href="https://use.typekit.net" crossorigin>
    <link rel="preconnect" href="https://p.typekit.net" crossorigin>
    <link rel="preload" as="style" href="<?= $font_url; ?>">
    <link rel="stylesheet" href="<?= $font_url; ?>" media="print" onload="this.media='all'" />
    <noscript><link rel="stylesheet" href="<?= $font_url ?>" /></noscript>
    <?php wp_head(); ?>
</head>
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-202635474-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'UA-202635474-1');
</script>
<?php

$flexibleSection = get_field('flexible_sections');
$bannerType = get_field('banner_type');
$bannerVideo = get_field('banner_video');

$id = ($flexibleSection[0]['acf_fc_layout'] == 'hero_section' && $flexibleSection[0]['hero_type'] == 'video') || (is_singular('model') && $bannerType == 'video' && $bannerVideo)  ? 'video-hero-set' : "";


?>

<body id="<?= $id; ?>" <?php body_class(); ?>>
