<?php
$gallery = get_field('gallery');
$social = get_field('instagram_handle');
$path = get_template_directory() . '/dist/images/MT_Logo_Black.svg';
$file = file_get_contents($path);
$file = str_replace(
    '<?xml version="1.0" encoding="UTF-8"?>',
    '',
    $file
);
?>

<div class="custom-model-single">
    <?php
    $bannerType = get_field('banner_type');
    $bannerVideo = get_field('banner_video');
    $bannerImage = get_field('banner_image');
    $image = wp_get_attachment_image_src($bannerImage['id'], 'banner-image');
    if($bannerType == 'image' && $bannerImage) {?>
        <div class="custom-flexible-section hero-section">
            <img src="<?= $image[0]; ?>" alt="<?php the_title(); ?>">
            <div class="name u-case fw-700"><div class="contain"><?php the_title(); ?></div></div>
        </div>
    <?php } elseif($bannerType == 'video' && $bannerVideo) { ?>
        <div class="custom-flexible-section hero-section">
            <video autoplay muted loop>
                <source src="<?= $bannerVideo['url']; ?>" type="video/mp4">
            </video>
            <div class="name u-case fw-700"><div class="contain"><?php the_title(); ?></div></div>
            <div class="video-state"><div class="contain"><span class="fal fa-volume-mute video-svg"></div></div>
        </div>
    <?php } ?>

    <nav>
        <div class="contain">
            <ul class="u-case fw-700">
                <li><a href="#info">Info</a></li>
                <?php if($gallery) { ?><li><a href="#portfolio">Portfolio</a></li><?php } ?>
                <?php if($social) { ?><li><a href="#social">Social</a></li><?php } ?>
            </ul>
        </div>
    </nav>

    <main>
        <section class="info-section" id="info">
            <div class="contain">
                <div class="info-wrapper">
                    <div class="primary-content">
                        <h1 class="u-case fw-700"><?= preg_replace('([a-zA-Z.,!?0-9]+(?![^<]*>))', '<span>$0</span>', get_the_title()); ?></h1>
                        <div class="table-wrapper">
                            <table class="stats">
                                <tbody>
                                <tr>
                                    <td>Height</td>
                                    <td>
                                        <span class="inches"><?php the_field('height_inches'); ?></span>
                                        <span class="centimetres"><?php the_field('height_centimetres'); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Hair</td>
                                    <td><?php the_field('hair'); ?></td>
                                </tr>
                                <tr>
                                    <td>Eyes</td>
                                    <td><?php the_field('eyes'); ?></td>
                                </tr>
                                <tr>
                                    <td>Bust</td>
                                    <td><?php the_field('bust'); ?></td>
                                </tr>
                                <tr>
                                    <td>Dress</td>
                                    <td><?php the_field('dress'); ?></td>
                                </tr>
                                <tr>
                                    <td>Waist</td>
                                    <td>
                                        <span class="inches"><?php the_field('waist_inches'); ?></span>
                                        <span class="centimetres"><?php the_field('waist_centimetres'); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Hips</td>
                                    <td>
                                        <span class="inches"><?php the_field('hips_inches'); ?></span>
                                        <span class="centimetres"><?php the_field('hips_centimetres'); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Shoes</td>
                                    <td>
                                        <span class="inches"><?php the_field('shoes_uk'); ?></span>
                                        <span class="centimetres"><?php the_field('shoes_eu'); ?></span>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>

                        <ul class="stat-toggle u-case fw-700">
                            <li class="inches active" data-measurement="inches"><a href="">Inches</a></li>
                            <li class="centimetres" data-measurement="centimetres"><a href="">CM</a></li>
                        </ul>

                    </div>
                    <div class="secondary-content">
                        <?php if(get_the_post_thumbnail_url()) { ?>
                            <div class="image-wrapper">
                                <img src="<?php the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </section>

        <?php if($gallery) { ?>
            <section class="portfolio-section" id="portfolio">
                <div class="contain">
                    <button class="toggle-type u-case fw-700"><span class="fas fa-th-large"></span> See <span class="number">2</span></button>
                    <div class="grid image-output">
                        <?php
                        $galleryCount = 0;
                        foreach($gallery as $image) { $galleryCount++; ?>
                            <div class="item">
                                <img src="<?= $image['gallery_image']['url']; ?>" onclick="openModal();currentSlide(<?= $galleryCount; ?>)" alt="<?= $image['gallery_image']['alt']; ?>" loading="lazy">
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </section>
        <?php } ?>

        <!-- Images used to open the lightbox -->
        <div class="modal-testing">
            <!-- The Modal/Lightbox -->
            <div id="myModal" class="modal">

                <div class="modal-top">
                    <div class="contain">
                        <div class="inner">
                            <div class="l-header__custom-theme-switcher">
                                <?php if(isset($_COOKIE['theme']) && $_COOKIE['theme'] == 'dark') { ?>
                                    <span class="fas fa-sun" id="theme-svg"></span>
                                <?php } else { ?>
                                    <span class="fas fa-moon" id="theme-svg"></span>
                                <?php } ?>
                            </div>
                            <a class="navbar-brand" href="<?= esc_url(home_url('/')); ?>">
                                <?php
                                echo str_replace(
                                    '<svg',
                                    '<svg class="l-header__logo" role="img" aria-label="Model Team"',
                                    $file
                                );
                                ?>
                            </a>
                            <div class="modal-toggle">
                                <button class="navigation-toggle__close" aria-label="Close Navigation" onclick="closeModal()"><span class="far fa-times close-icon"></span></button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-content">
                    <div class="contain">


                        <?php
                        $slideCount = 0;
                        foreach($gallery as $image) { $slideCount++; ?>
                            <div class="mySlides">
                                <div class="number-text fw-700"><?= $slideCount; ?> / <?= count($gallery); ?></div>
                                <img src="<?= $image['gallery_image']['url']; ?>">
                            </div>
                        <?php } ?>

                        <!-- Next/previous controls -->
                        <a class="prev" onclick="plusSlides(-1)"><span class="fal fa-chevron-left"></span></a>
                        <a class="next" onclick="plusSlides(1)"><span class="fal fa-chevron-right"></span></a>

                    </div>

                    <div class="stats-overlay">
                        <div class="contain">
                            <ul class="stats">
                                <li>
                                    <strong>Height</strong>
                                    <span class="inches"><?php the_field('height_inches'); ?></span>
                                    <span class="centimetres"><?php the_field('height_centimetres'); ?></span>
                                </li>
                                <li><strong>Hair</strong> <?php the_field('hair'); ?></li>
                                <li><strong>Eyes</strong> <?php the_field('eyes'); ?></li>
                                <li><strong>Bust</strong> <?php the_field('bust'); ?></li>
                                <li><strong>Dress</strong> <?php the_field('dress'); ?></li>
                                <li>
                                    <strong>Waist</strong>
                                    <span class="inches"><?php the_field('waist_inches'); ?></span>
                                    <span class="centimetres"><?php the_field('waist_centimetres'); ?></span>
                                </li>
                                <li>
                                    <strong>Hips</strong>
                                    <span class="inches"><?php the_field('hips_inches'); ?></span>
                                    <span class="centimetres"><?php the_field('hips_centimetres'); ?></span>
                                </li>
                                <li>
                                    <strong>Shoes</strong>
                                    <span class="inches"><?php the_field('shoes_uk'); ?></span>
                                    <span class="centimetres"><?php the_field('shoes_eu'); ?></span>
                                </li>
                            </ul>
                            <ul class="toggle u-case fw-700">
                                <li class="inches active" data-measurement="inches"><a href="">Inches</a></li>
                                <li class="centimetres" data-measurement="centimetres"><a href="">CM</a></li>
                            </ul>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        <script>
            // Open the Modal
            function openModal() {
                document.getElementById("myModal").style.display = "flex";
            }

            // Close the Modal
            function closeModal() {
                document.getElementById("myModal").style.display = "none";
            }

            var slideIndex = 1;
            showSlides(slideIndex);

            // Next/previous controls
            function plusSlides(n) {
                showSlides(slideIndex += n);
            }

            // Thumbnail image controls
            function currentSlide(n) {
                showSlides(slideIndex = n);
            }

            function showSlides(n) {
                var i;
                var slides = document.getElementsByClassName("mySlides");
                var dots = document.getElementsByClassName("demo");
                var captionText = document.getElementById("caption");
                if (n > slides.length) {slideIndex = 1}
                if (n < 1) {slideIndex = slides.length}
                for (i = 0; i < slides.length; i++) {
                    slides[i].style.display = "none";
                }
                for (i = 0; i < dots.length; i++) {
                    dots[i].className = dots[i].className.replace(" active", "");
                }
                slides[slideIndex-1].style.display = "flex";
                dots[slideIndex-1].className += " active";
                captionText.innerHTML = dots[slideIndex-1].alt;
            }
        </script>



        <?php if($social) { ?>
            <section class="social-section" id="social">

            </section>
        <?php } ?>
    </main>
</div>
