<?php
namespace Blue2\Scruffy\Controllers;

class InstagramController
{
    public function __construct()
    {
        $this->username = "modelteamscotland";
        $this->url = "https://www.instagram.com/".$this->username."/channel/?__a=1&ig_pr=2/";
        $this->instagramPhotos = [];
        add_action('rest_api_init', function () {
            register_rest_route('model-team/v1', '/get-insta-feed/', [
                'methods' => 'GET',
                'callback' => [$this, 'getFeed'],
            ]);
        });
    }
    private function getData(){
        $time = intval(get_field('instagram_time', 'option'));
        $now = strtotime('now');
        $future = strtotime( "+1 days", $time);
        if($time != null && $now <= $future){
            $instaArray = json_decode(get_field('instagram_data', 'option'));
        }else{
            $instaResult = file_get_contents($this->url);
            $insta = json_decode($instaResult);
            $instaArray = self::createInstaArray($insta);
            update_field('instagram_data', json_encode($instaArray), 'option');
            update_field('instagram_time', strtotime('now'), 'option');
        }
        return $instaArray;
    }
    private function createInstaArray($insta){
        $instagramPhotoItems = $insta->graphql->user->edge_owner_to_timeline_media->edges;
        foreach($instagramPhotoItems as $item){
            $this->instagramPhotos[] = [
                "image" => 'data:image/jpg;base64,' . base64_encode(file_get_contents($item->node->thumbnail_resources[4]->src)),
                "link" => 'https://www.instagram.com/p/' . $item->node->shortcode
            ];
        }

        $followerCount = $insta->graphql->user->edge_followed_by;

        $data = [
            'follower_count' => $followerCount,
            'photos' => $this->instagramPhotos
        ];

        return $data;
    }
    public function getFeed(){
        $insta = self::getData();
        if($insta == null) return false;
        return $insta;
    }
}
