<?php
namespace Blue2\Scruffy\Controllers;

class ModelController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'addModelTypeEndpoints']);
        add_action('init', [$this, 'registerTaxonomies']);
    }

    private function registerFilters()
    {
        add_filter('request', [$this, 'modelTypeFilterRequest']);
    }

    function modelTypeFilterRequest( $vars )
    {
        if( isset( $vars['male'] ) ) $vars['male'] = true;
        if( isset( $vars['female'] ) ) $vars['female'] = true;
        if( isset( $vars['test123'] ) ) $vars['test123'] = true;
        return $vars;
    }

    public function addModelTypeEndpoints()
    {
        global $wp_rewrite;
        add_rewrite_endpoint('male', EP_PERMALINK | EP_PAGES | EP_CATEGORIES);
        add_rewrite_endpoint('female', EP_PERMALINK | EP_PAGES | EP_CATEGORIES);
        add_rewrite_endpoint('test123', EP_ALL);
        $wp_rewrite->flush_rules();
    }

    public function registerTaxonomies()
    {
        $modelGender = new \Blue2\Common\Taxonomy("gender", "Gender", "Genders", "model", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);

        $modelType = new \Blue2\Common\Taxonomy("type", "Type", "Types", "model", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
    }
}
