import { fontawesome, throttle } from './utils';
import Swiper from 'swiper';

const common = () => {
    fontawesome();
    const currentTheme = localStorage.getItem('theme') ? localStorage.getItem('theme') : null;
    const themeSwitcher = $('.l-header__custom-theme-switcher');
    const imageCount = $('.image-load').length;

    if (currentTheme) {
        document.documentElement.setAttribute('data-theme', currentTheme);
    }

    $(themeSwitcher).on('click', function() {
        const icon = $(themeSwitcher).find('svg');
        const iconFaIcon = icon.attr('data-icon');
        if (document.documentElement.getAttribute('data-theme') === 'dark') {
            iconFaIcon === 'sun' ? icon.attr('data-icon', 'moon') : icon.attr('data-icon', 'sun');
            document.documentElement.setAttribute('data-theme', 'light');
            localStorage.setItem('theme', 'light');
            document.cookie = 'theme=light';
        } else {
            iconFaIcon === 'moon' ? icon.attr('data-icon', 'sun') : icon.attr('data-icon', 'moon');
            document.documentElement.setAttribute('data-theme', 'dark');
            localStorage.setItem('theme', 'dark');
            document.cookie = 'theme=dark';
        }
    });

    $('.main-nav-link').on('click', function(e) {
        e.preventDefault();
    });

    $('.navigation-toggle button').on('click', function() {
        $('.menu-overlay').toggleClass('active');
    });

    if ($('.block-slider').length) {
        new Swiper('.swiper-block-slider', {
            loop: true,
            lazy: true,
            pagination: {
                el: '.swiper-pagination',
                type: 'bullets',
                clickable: true,
            },
            breakpoints: {
                0: {
                    slidesPerView: 1,
                    spaceBetween: 32
                },
                512: {
                    slidesPerView: 2,
                    spaceBetween: 32
                },
                992: {
                    spaceBetween: 32,
                    slidesPerView: 3,
                }
            },
        });
    }

    if ($('.instagram-feed-slider').length) {
        new Swiper('.swiper-instagram-slider', {
            pagination: {
                el: '.swiper-pagination',
                type: 'bullets',
                clickable: true,
            },
            breakpoints: {
                0: {
                    slidesPerView: 1,
                    spaceBetween: 32
                },
                512: {
                    slidesPerView: 2,
                    spaceBetween: 32
                },
                992: {
                    spaceBetween: 32,
                    slidesPerView: 3,
                }
            },
        });
    }

    function unloadImg(index) {
        let imageIndex = index;
        if (imageIndex === null) {
            imageIndex = imageCount;
        }
        if (imageIndex > 0) {
            const timer = setTimeout(function() {
                $(`.load-${imageIndex}`).fadeOut();
                clearTimeout(timer);
                imageIndex--;
                unloadImg(imageIndex);
            }, 1000);
        } else {
            $('#start-loader').fadeOut();
            $('html, body').css({
                overflow: 'auto',
                height: 'auto'
            });
            document.cookie = 'startLoader=set';
        }
    }

    function animateValue(obj, start, end, duration) {
        let startTimestamp = null;
        const step = timestamp => {
            if (!startTimestamp) {
                startTimestamp = timestamp;
            }
            const progress = Math.min((timestamp - startTimestamp) / duration, 1);
            obj.innerHTML = Math.floor(progress * (end - start) + start);
            if (progress < 1) {
                window.requestAnimationFrame(step);
            }
        };
        window.requestAnimationFrame(step);
    }

    function getCookie(name) {
        const dc = document.cookie;
        const prefix = `${name}=`;
        let begin = dc.indexOf(`; ${prefix}`);
        let end = document.cookie.indexOf(';', begin);
        if (begin === -1) {
            begin = dc.indexOf(prefix);
            if (begin !== 0) {
                return null;
            }
        } else {
            begin += 2;
            if (end === -1) {
                end = dc.length;
            }
        }
        return decodeURI(dc.substring(begin + prefix.length, end));
    }

    if (!getCookie('startLoader')) {
        const percentageCounter = document.getElementById('value');
        $('html, body').css({
            overflow: 'hidden',
            height: '100%'
        });
        animateValue(percentageCounter, 0, 100, 3000);
        setTimeout(function() {
            $('#start-loader').fadeOut();
            $('html, body').css({
                overflow: 'auto',
                height: 'auto'
            });
            document.cookie = 'startLoader=set';
        }, 3000);
    }

    $(document).ready(function() {
        $('.video-wrapper video').on('mouseover', function() {
            this.pause();
        })
            .on('mouseout', function() {
                this.play();
            });
    });

    if ($('.s-instagramFeed__items').length > 0) {
        $.ajax({
            url: 'wp-json/model-team/v1/get-insta-feed/'
        }).done(function(data) {
            if (data['photos'].length > 0) {
                $('.s-instagramFeed__item').each(function(i) {
                    $(this).find('.s-instagramFeed__progress')
                        .hide();
                    $(this).find('a')
                        .attr('href', data['photos'][i]['link']);
                    $(this).find('.s-instagramFeed__itemImg')
                        .attr('src', data['photos'][i]['image']);
                });
            }
        })
            .fail(function(e) {
                console.log('error with instagram');
                console.log(e);
            });
    }

    $('.female-menu-link').on('mouseover', function() {
        $('.male-menu').hide();
        $('.female-menu').show();
    });

    $('.male-menu-link').on('mouseover', function() {
        $('.female-menu').hide();
        $('.male-menu').show();
    });

    $('.female-menu').on('mouseleave', function() {
        $('.female-menu').hide();
    });

    $('.male-menu').on('mouseleave', function() {
        $('.male-menu').hide();
    });
};

export default common;
