<?php
$contactEmail = get_field('contact_email_address', 'option');
$contactPhone = get_field('contact_phone_number', 'option');
$socials = get_field('social_media_channels', 'option');
$address = get_field('company_address', 'option');
?>

<footer class="l-footer fw-700">
    <div class="l-footer__contain contain">
        <hr/>
        <div class="top-row row">
            <div class="col-md-6 col-lg-5 caption-col">
                <?php the_field('company_caption' ,'options'); ?>
            </div>
            <div class="col-md-6 col-lg-3 contact-col">
                <?php if($contactEmail || $contactPhone) { ?>
                    <ul>
                        <?php if($contactPhone) { ?><li><span>Call</span> <a href="tel:<?= $contactPhone; ?>"><?= $contactPhone; ?></a></li><?php } ?>
                        <?php if($contactEmail) { ?><li><span>Email</span> <a href="mailto:<?= $contactEmail; ?>"><?= $contactEmail; ?></a></li><?php } ?>
                    </ul>
                <?php } ?>
            </div>
            <div class="col-md-6 col-lg-2 social-col">
                <?php if($socials) { ?>
                    <ul>
                        <?php foreach($socials as $social) { ?>
                            <li><a href="<?= $social['full_url']; ?>" target="_blank"><?= $social['platform']; ?></a></li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>
            <div class="col-md-6 col-lg-2 address-col">
                <?php if($address) { ?>
                    <?= $address; ?>
                <?php } ?>
            </div>
        </div>
        <div class="bottom-row">
            <div class="copyright">
                &copy; <?= get_the_date('Y'); ?> <?php the_field('company_name', 'option'); ?>
            </div>
            <div class="website-by">
                Website by <a href="http://blue2.co.uk">blue2</a>
            </div>
        </div>
    </div>
</footer>
