<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\ModelController;

class Site extends \Blue2\Common\Site
{
    public function __construct() {
        parent::__construct();

        add_theme_support('post-thumbnails');
        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus() {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu'
        ]);
    }

    public function tidyExcerpt() {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    private function registerShortCodes() {
        // Empty
    }

    private function registerFilters() {
        add_filter('walker_nav_menu_start_el', [$this, 'addChevronToMenuItemsWithChildren'], 10, 4 );
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('init', [$this, 'customImageSizes']);
        add_action('admin_menu', [$this, 'customAdminPages']);
    }

    private function setupControllers() {
        new ModelController();
    }

    public function registerPostTypes(){
        Post\Model::registerPostType();
    }

    public function customImageSizes()
    {
        add_image_size('model-menu-type', 372, 209, true);
        add_image_size('large-square-image', 501, 501, true);
        add_image_size('model-archive-image', 356, 445, true);
        add_image_size('banner-image', 1880, 850, true);

        add_image_size('flexible-split-25', 356, 0, false);
        add_image_size('flexible-split-40', 625, 0, false);
        add_image_size('flexible-split-50', 760, 0, false);
        add_image_size('flexible-split-60', 895, 0, false);
        add_image_size('flexible-split-75', 1164, 0, false);

    }

    public function addChevronToMenuItemsWithChildren( $item_output, $item, $depth, $args ) {
        if ( $args->theme_location == 'main_menu' && $args->menu_class == 'main-navigation') {
            if ( in_array( 'menu-item-has-children', $item->classes ) || in_array( 'page_item_has_children', $item->classes ) ) {
                $item_output = str_replace( $args->link_after . '</a>', $args->link_after . '<span class="fal fa-chevron-down" class="menu-svg"></span>', $item_output );
            }
        }
        return $item_output;
    }


    public function customAdminPages()
    {
        if (function_exists('acf_add_options_page')) {
            acf_add_options_page([
                'title' => 'Model Settings',
                'parent' => 'edit.php?post_type=model',
                'capability' => 'edit_posts',
            ]);
        }
    }

    public static function getDefaultImage() {
        $path = get_template_directory() . '/dist/images/MT_Logo_Black.svg';
        $file = file_get_contents($path);
        // remove xml header
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );
        // add class and attributes for accessibility
        return str_replace(
            '<svg',
            '<svg class="default-logo" role="img" aria-label="Model Team"',
            $file
        );
    }


}
