import Swiper from 'swiper';
import Magnific from 'magnific-popup';

const common = () => {
    new Swiper ('.news-swiper', {
        direction: 'horizontal',
        loop: true,
        spaceBetween: 50,
        slidesPerView: 3,
        breakpoints: {
            768: {
                centeredSlides: true,
                slidesPerView: 1,
            },
            992: {
                slidesPerView: 2,
            },
            1200: {
                slidesPerView: 3,
            }
        }
    });

    $('.navbar-toggler').on('click', function() {
        $('.navbar-toggler svg').toggleClass('fa-bars fa-times');
    });

    $('#trigger-video').on('click', function(e) {
        e.preventDefault();
        $('.main-video-block').addClass('active-video');
        $('#featured-video')[0].play();
    });

    $('.back').on('click', function(e) {
        e.preventDefault();
        $('.main-video-block').removeClass('active-video');
        $('#featured-video')[0].pause();
    });

    $('.scroll-to').on('click', function() {
        $('html,body').animate({
            scrollTop: $('.custom-flexible-section:nth-child(2)').offset().top }
        , 'slow');
    });

    $('.scroll-to-contact').on('click', function(e) {
        e.preventDefault();
        $('html,body').animate({
            scrollTop: $('.contact-section').offset().top }
        , 'slow');
    });

    if ($('.gallery-section').length) {
        $('.image-link').magnificPopup({
            type: 'image',
            gallery:{
                enabled:true
            }
        });
    }

    if ($('body#hero-is-video').length > 0) {
        const element = $('.hero-section');
        const height = $('.hero-section').offsetHeight;
        const top = $('.hero-section').offsetTop;
        const elementBottom = element.offsetTop + element.offsetHeight;
        console.log(element);
        console.log(elementBottom);
        console.log(height);
        console.log(top);
    }
};

export default common;
