<?php $heroType = get_sub_field('hero_type'); ?>

<div class="custom-flexible-section hero-section <?= 'type-' . $heroType; ?>">
    <?php if($heroType == 'image') {
        $image = get_sub_field('hero_image'); ?>
        <div class="image-holder">
            <img src="<?= $image['url']; ?>">
        </div>
    <?php } else {
        $previewVideo = get_sub_field('hero_video_preview');
        $mainVideo = get_sub_field('hero_video_full');
        $opaqueLogo = get_template_directory_uri() . '/dist/images/opaque-logo.png';
        ?>
        <div class="video-holder">
            <video autoplay muted loop>
                <source src="<?= $previewVideo['url']; ?>" type="video/mp4">
            </video>
            <div class="video-overlay">
                <div class="video-image"><img src="<?= get_template_directory_uri() . '/dist/images/video-overlay.png'; ?>" alt="#LoveDougalston"></div>
                <div class="cta">
                    <a href="" id="trigger-video">Watch Video</a>
                </div>
            </div>
            <div class="scroll-to">
                <div class="bar"></div>
                <div class="show-text">Learn More</div>
            </div>
        </div>
        <div class="main-video-block">
            <div class="back"><i class="far fa-arrow-left"></i> Back</div>
            <img src="<?= $opaqueLogo; ?>">
            <div class="container">
                <div class="inner-video-holder">
                    <video id="featured-video" controls>
                        <source src="<?= $mainVideo['url']; ?>" type="video/mp4">
                    </video>
                </div>
            </div>
        </div>
    <?php } ?>
</div>

