<?php
$galleryItems = get_sub_field('gallery_items');
$count = count($galleryItems);
if($galleryItems) {?>
    <div class="custom-flexible-section gallery-section">
        <div class="gallery-grid <?= 'count-' . $count; ?>">
            <?php foreach($galleryItems as $item) { ?>
                <div class="holder">
                    <a href="<?= $item['image']['url']; ?>" class="image-link">
                        <div class="interact-overlay"><i class="far fa-search-plus"></i></div>
                        <img src="<?= $item['image']['url']; ?>">
                    </a>
                </div>
            <?php } ?>
        </div>
        <div class="container">
            <?php $belowGalleryCTA = get_sub_field('below_gallery_cta');
            if($belowGalleryCTA) { ?>
                <div class="gallery-cta">
                    <a href="<?= $belowGalleryCTA['url']; ?>"><?= $belowGalleryCTA['title']; ?></a>
                </div>
            <?php } ?>
        </div>
    </div>
<?php } ?>
