<?php
$title = get_sub_field('title') ?: 'Contact Us';
$shortcode = get_sub_field('contact_form_shortcode');
$description = get_sub_field('description');

$phone = get_field('contact_phone_number', 'option');
$email = get_field('contact_email_address', 'option');

?>

<div class="custom-flexible-section contact-section">
    <div class="container">
        <h2><?= $title; ?></h2>
        <div class="row">
            <div class="col-lg-8">
                <div class="description"><?= $description; ?></div>
                <div class="form"><?= do_shortcode($shortcode); ?></div>
            </div>
            <div class="col-lg-4">
                <?php if($email) { ?><div class="contact-item"><i class="far fa-envelope"></i> <a href="mailto:<?= $email ?>"><?= $email; ?></a></div><?php } ?>
                <?php if($phone) { ?><div class="contact-item"><i class="far fa-phone"></i> <a href="tel:<?= $phone ?>"><?= $phone; ?></a></div><?php } ?>
            </div>
        </div>
    </div>
</div>
