<?php
$query = new WP_Query([
    'post_type' => 'post',
    'posts_per_page' => 10,
    'post_status' => 'publish'
]);
$companyLogo = get_field('company_logo', 'option');

if( $query->have_posts() ) {?>
    <div class="custom-flexible-section news-block news-swiper-section" id="news-section">

        <div class="container">
            <div class="news-header">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="news-section-header">
                            <h2>News</h2>
                            <span><a href="/news/">View All</a></span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="swiper-container news-swiper">
                <div class="swiper-wrapper">
                    <?php while ($query->have_posts()) {
                        $query->the_post();
                        $image = get_the_post_thumbnail_url() ?: $companyLogo['url'];
                        $imageClass = get_the_post_thumbnail_url() ? 'custom-featured' : 'custom-default';
                        ?>
                        <div class="swiper-slide">
                            <div class="new-swiper-item">
                                <div class="image-holder <?= $imageClass; ?>">
                                    <a href="<?php the_permalink(); ?>">
                                        <img src="<?= $image; ?>" alt="<?php the_title(); ?>">
                                    </a>
                                </div>
                                <div class="content-holder">
                                    <h4><?= get_the_date(); ?></h4>
                                    <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                </div>
                            </div>
                        </div>
                    <?php } wp_reset_postdata(); ?>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
