import Swiper from 'swiper';

const common = () => {
    new Swiper ('.news-swiper', {
        direction: 'horizontal',
        loop: true,
        spaceBetween: 50,
        slidesPerView: 3,
        breakpoints: {
            768: {
                centeredSlides: true,
                slidesPerView: 1,
            },
            992: {
                slidesPerView: 2,
            },
            1200: {
                slidesPerView: 3,
            }
        }
    });

    $('.navbar-toggler').on('click', function() {
        $('.navbar-toggler svg').toggleClass('fa-bars fa-times');
    });

    $('#trigger-video').on('click', function(e) {
        e.preventDefault();
        $('.main-video-block').addClass('active-video');
        $('#featured-video')[0].play();
    });

    $('.back').on('click', function(e) {
        e.preventDefault();
        $('.main-video-block').removeClass('active-video');
        $('#featured-video')[0].pause();
    });

    $('.scroll-to').on('click', function() {
        console.log('clicked');
        $('html,body').animate({
            scrollTop: $('.custom-flexible-section:nth-child(2)').offset().top }
        , 'slow');
    });
};

export default common;
