<?php
$heroType = get_sub_field('hero_type');
?>

<div class="custom-flexible-section hero-section <?= 'type-' . $heroType; ?>">
    <?php if($heroType == 'image') {
        $image = get_sub_field('hero_image'); ?>
        <div class="image-holder">
            <img src="<?= $image['url']; ?>">
        </div>
    <?php } else {
        $previewVideo = get_sub_field('hero_video_preview'); ?>
        <div class="video-holder">

            <video autoplay muted>
                <source src="<?= $previewVideo['url']; ?>" type="video/mp4">
            </video>

            <div class="video-overlay">
                <div class="video-image"><img src="<?= get_template_directory_uri() . '/dist/images/video-overlay.png'; ?>" alt="#LoveDougalston"></div>
                <div class="cta">
                    <a href="" id="trigger-video">Watch Video</a>
                </div>
            </div>

            <div class="scroll-to">
                <div class="bar"></div>
                <div class="show-text">Learn More</div>
            </div>

        </div>


    <?php } ?>
</div>
