<?php $heroType = get_sub_field('hero_type'); ?>

<div class="custom-flexible-section hero-section <?= 'type-' . $heroType; ?>">
    <?php if ($heroType == 'image') {
        $image = get_sub_field('hero_image'); ?>
        <div class="image-holder" style="background-image:url(<?= $image['url']; ?>)">

        </div>
    <?php } elseif ($heroType == 'image-text') {
        $image = get_sub_field('hero_image');
        $customText = get_sub_field('hero_custom_text')
    ?>
        <div class="image-holder" style="background-image:url(<?= $image['url']; ?>)">
            <div class="container">
                <div class="title-holder">
                    <div class="row">
                        <div class="col-lg-12">
                            <h1><?= $customText; ?></h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <?php } else {
        $previewVideo = get_sub_field('hero_video_preview');
        $mainVideo = get_sub_field('hero_video_full');
        $opaqueLogo = get_template_directory_uri() . '/dist/images/opaque-logo.png';
        $hideWatchVideoButton = get_sub_field('hide_watch_video_button');
    ?>
        <div class="video-holder">
            <video autoplay muted loop>
                <source src="<?= $previewVideo['url']; ?>" type="video/mp4">
            </video>
            <div class="video-overlay">
                <div class="video-image"><img src="<?= get_template_directory_uri() . '/dist/images/video-overlay.png'; ?>" alt="#LoveDougalston"></div>
                <?php if (!$hideWatchVideoButton) { ?>
                    <div class="cta video-activate-cta">
                        <a href="" id="trigger-video">Watch Video</a>
                    </div>
                <?php } ?>
            </div>
            <div class="scroll-to">
                <div class="bar"></div>
                <div class="show-text">Learn More</div>
            </div>
        </div>
        <div class="main-video-block" style="background-image:url('<?= get_template_directory_uri() . '/dist/images/bg-pattern.png'; ?>')">
            <div class="back"><i class="far fa-arrow-left"></i> Back</div>
            <img src="<?= $opaqueLogo; ?>">
            <div class="container">
                <div class="inner-video-holder">
                    <video id="featured-video" controls>
                        <source src="<?= $mainVideo['url']; ?>" type="video/mp4">
                    </video>
                </div>
            </div>
        </div>
    <?php } ?>
</div>
