<?php
$partners = get_field('partner_logos');
$phone = get_field('contact_phone_number', 'option');
$email = get_field('contact_email_address', 'option');
?>

<div class="custom-contact-template">
    <div class="custom-flexible-section hero-section type-image">
        <?php $image = get_the_post_thumbnail_url(); ?>
        <div class="image-holder" style="background-image:url(<?= $image ?>)">
        </div>
    </div>

    <div class="contact-block">
        <div class="container">
            <div class="section-holder">
                <h1><?php the_title(); ?></h1>
                <div class="description"><?php the_content(); ?></div>
                <div class="row">
                    <div class="col-lg-8">
                        <div class="form-holder">
                            <?= do_shortcode(get_field('contact_form_shortcode')); ?>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="sidebar-holder">
                            <?php if($email) { ?><div class="contact-item">Email us at:<br/><a href="mailto:<?= $email ?>"><?= $email; ?></a></div><?php } ?>
                            <?php if($phone) { ?><div class="contact-item">Phone us on:<br/><a href="tel:<?= $phone ?>"><?= $phone; ?></a></div><?php } ?>
                            <?php if (have_rows('social_media_channels', 'option')) { ?>
                            <div class="socials">
                                <p>Follow us on social media</p>
                                <ul>
                                    <?php while (have_rows('social_media_channels', 'option')) {
                                        the_row(); ?>
                                        <li>
                                            <a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener">
                                        <span class="fa-stack fa-2x">
                                          <i class="fal fa-circle fa-stack-2x"></i>
                                          <i class="<?php the_sub_field('fa5_icon_class'); ?> fa-stack-1x fa-inverse social-icon"></i>
                                        </span>
                                            </a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div>
                            <?php } ?>
                            <div class="email-form pt-5">
                                <script charset="utf-8" type="text/javascript" src="//js.hsforms.net/forms/shell.js"></script>
                                <script>
                                    hbspt.forms.create({
                                        portalId: "8865894",
                                        formId: "e770d613-9aba-4bee-9198-8cf4d9d5f48f"
                                    });
                                </script>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if($partners) { ?>
        <div class="partner-block">
            <div class="container">
                <div class="row row-eq-height">
                    <?php foreach($partners as $partner) { ?>
                        <div class="col-lg-4 d-flex align-items-center justify-content-center partner-col">
                            <div class="partner-inner">
                                <a href="<?= $partner['partner_website_url']; ?>" target="_blank">
                                    <img src="<?= $partner['partner_logo']['url']; ?>" alt="<?= $partner['partner_name']; ?>">
                                </a>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    <?php } ?>
</div>

<div class="flexible-layout-sections">
    <?php Blue2\Scruffy\Utils::flexibleLoop('flexible_sections', 'option'); ?>
</div>
