<?php
$opaqueLogo = get_template_directory_uri() . '/dist/images/opaque-logo.png';
$greenBg = get_template_directory_uri() . '/dist/images/green-pattern.jpg';
$pageForPosts = get_option( 'page_for_posts' );
$newsArchiveImage = get_field('news_archive_image', 'option') ? get_field('news_archive_image', 'option')['url'] : $greenBg;
?>

<div class="custom-archive">

    <div class="custom-flexible-section hero-section type-image">
        <div class="image-holder" style="background-image:url(<?= $newsArchiveImage ?>)">
            <div class="container">
                <div class="title-holder">
                    <div class="row">
                        <div class="col-lg-12">
                            <h1><?= get_the_title($pageForPosts); ?></h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="container archive-container" style="background-image:url(<?= $opaqueLogo; ?>)">
        <div class="archive-listing">
            <div class="row">
                <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
            </div>
        </div>
        <div class="custom-pagination">
            <?php
            the_posts_pagination([
                'mid_size' => 1,
                'prev_text' => __('Previous', 'textdomain'),
                'next_text' => __('Next', 'textdomain'),
                'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
            ]); ?>
        </div>
    </div>
</div>
<div class="flexible-layout-sections">
    <?php Blue2\Scruffy\Utils::flexibleLoop('flexible_sections', $pageForPosts); ?>
</div>
