<?php
$order = get_sub_field('split_order');
$title = get_sub_field('title');
$content = get_sub_field('content');
$primaryImage = get_sub_field('primary_image');
$secondaryImage = get_sub_field('secondary_image');

$imageColOrder = $order == 'text-first' ? 'order-2 col-lg-6' : 'order-1 col-lg-6';
$contentColOrder = $order == 'image-first' ? 'content-last order-2 col-lg-6' : 'order-1 col-lg-6';

?>
<div class="custom-flexible-section split-section">
    <div class="container">
        <div class="row">
            <div class="<?= $contentColOrder; ?> content-col">
                <?php if($title) { ?><h2><?= $title; ?></h2><?php } ?>
                <div class="decription"><?= $content; ?></div>
            </div>
            <div class="<?= $imageColOrder; ?> image-col">
                <div class="holder">
                    <?php if($primaryImage) { ?><img src="<?= $primaryImage['url']; ?>" alt="<?= $primaryImage['alt']; ?>"><?php } ?>
                    <?php if($secondaryImage) { ?><img src="<?= $secondaryImage['url']; ?>" alt="<?= $secondaryImage['alt']; ?>" class="secondary-image"><?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>
