<?php
namespace Blue2\Scruffy;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu'
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        add_filter('wp_enqueue_scripts', [$this, 'enqueueScripts']);
        add_filter('acf/fields/google_map/api', [$this, 'myAcfGoogleMapApi']);
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('init', [$this, 'customOptionsPages']);
    }

    private function setupControllers(){
        //Empty
    }

    public function registerPostTypes()
    {
        Post\Quote::registerPostType();
    }

    public static function outputGalleryGrid($images)
    {
        if ($images) { ?>
            <div class="grid-gallery">
                <div class="grid-sizer"></div>
                <div class="gutter-sizer"></div>
                <?php foreach ($images as $key => $image) {
                    $imageURL = $image['url'];
                    $imageWidth = $image['width'];
                    $imageHeight = $image['height'];
                    $imageCaption = $image['alt'];
                    ?>
                    <div class="grid-item" data-index="<?= $key ?>" style=" height: 240px;">
                        <img data-src="<?= $imageURL ?>" data-fullsrc="<?= $imageURL ?>"
                             data-fullwidth="<?= $imageWidth ?>" data-fullheight="<?= $imageHeight ?>"
                             alt="<?= $imageCaption ?>" data-caption="<?= $imageCaption ?>" class="img-fluid lazy">
                    </div>
                <?php } ?>
            </div>
        <?php } else { ?>
            <p class="text-center"><strong>There were no images added</strong></p>
        <?php };
    }

    public function enqueueScripts()
    {
        wp_enqueue_script('google-maps', '//maps.googleapis.com/maps/api/js?key=AIzaSyABZgG0ot3voSwR7mxGBHIaLgstlPv6q1Q', ['jquery'], null, true);
    }

    public function myAcfGoogleMapApi($api)
    {
        $api['key'] = 'AIzaSyABZgG0ot3voSwR7mxGBHIaLgstlPv6q1Q';
        return $api;
    }

    public function customOptionsPages()
    {
        if (function_exists('acf_add_options_page')) {
            acf_add_options_page([
                'title' => 'News Settings',
                'parent' => 'edit.php',
                'capability' => 'edit_posts',
            ]);
        }
    }


}
