<?php
$primaryImage = get_the_post_thumbnail_url();
$postContClass = ($primaryImage || $secondaryImage) ? 'image-active offset-lg-6 col-lg-6' : 'col-lg-8';
$postFluidClass = ($primaryImage || $secondaryImage) ? 'image-active' : 'image-inactive';
$opaqueLogo = get_template_directory_uri() . '/dist/images/opaque-logo.png';
?>

<div class="custom-single-post">

    <div class="container post-cont">
        <div class="blog-title">
            <h1><?php the_title(); ?></h1>
            <p class="date"><?= get_the_date(); ?></p>
        </div>
        <?php if($primaryImage) { ?><div class="image-holder"><img src="<?= $primaryImage ?>" alt="<?php the_title(); ?>"></div><?php } ?>
        <div class="content-holder">
            <?php the_content(); ?>
        </div>
    </div>



</div>
<?php
$query = new WP_Query([
    'post_type' => 'post',
    'posts_per_page' => 3,
    'post_status' => 'publish',
    'post__not_in' => [get_the_id()]
]);
$companyLogo = get_field('company_logo', 'option');
if( $query->have_posts() ) { ?>
    <div class="related-news-posts">
        <div class="container">
            <h2>Related News</h2>
            <div class="archive-listing">
                <div class="row">
                    <?php while ($query->have_posts()) {
                        $query->the_post();
                        $image = get_the_post_thumbnail_url() ?: $companyLogo['url'];
                        $imageClass = get_the_post_thumbnail_url() ? 'custom-featured' : 'custom-default'; ?>
                        <div class="col-lg-6 col-xl-4 archive-col">
                            <div class="archive-item">
                                <div class="image-holder <?= $imageClass; ?>">
                                    <a href="<?php the_permalink(); ?>">
                                        <img src="<?= $image; ?>" alt="<?php the_title(); ?>">
                                    </a>
                                </div>
                                <div class="content-holder">
                                    <h4><?= get_the_date(); ?></h4>
                                    <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
<?php } ?>

<div class="flexible-layout-sections">
    <?php Blue2\Scruffy\Utils::flexibleLoop('flexible_sections', 'option'); ?>
</div>

