<?php
$quoteBg = get_template_directory_uri() . '/dist/images/bg-pattern.png';
$quotes = get_sub_field('quotes');
$title = get_sub_field('quote_swiper_title');
?>

<div class="custom-flexible-section quote-swiper-section" style="background-image:url('<?= $quoteBg; ?>')">
    <div class="container">
        <?php if($title) { ?><h2><?= $title; ?></h2><?php } ?>
        <div class="swiper-container quote-swiper">
            <div class="swiper-wrapper">
                <?php foreach($quotes as $quote) { ?>
                    <div class="swiper-slide">
                        <div class="quote-inner">
                            <div class="quote-content"><?= $quote->post_content; ?></div>
                            <div class="quote-by"><?= $quote->post_title; ?></div>
                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>

    </div>
</div>
