import Swiper from 'swiper';
import Magnific from 'magnific-popup';

const common = () => {
    new Swiper ('.news-swiper', {
        direction: 'horizontal',
        loop: true,
        spaceBetween: 50,
        slidesPerView: 3,
        breakpoints: {
            768: {
                centeredSlides: true,
                slidesPerView: 1,
            },
            992: {
                slidesPerView: 2,
            },
            1200: {
                slidesPerView: 3,
            }
        }
    });

    $('.navbar-toggler').on('click', function() {
        $('.navbar-toggler svg').toggleClass('fa-bars fa-times');
    });

    $('#trigger-video').on('click', function(e) {
        e.preventDefault();
        $('.main-video-block').addClass('active-video');
        $('#featured-video')[0].play();
    });

    $('.back').on('click', function(e) {
        e.preventDefault();
        $('.main-video-block').removeClass('active-video');
        $('#featured-video')[0].pause();
    });

    $('.scroll-to').on('click', function() {
        $('html,body').animate({
            scrollTop: $('.custom-flexible-section:nth-child(2)').offset().top }
        , 'slow');
    });

    $('.scroll-to-contact').on('click', function(e) {
        e.preventDefault();
        $('html,body').animate({
            scrollTop: $('.contact-section').offset().top }
        , 'slow');
    });

    if ($('.gallery-section').length) {
        $('.image-link').magnificPopup({
            type: 'image',
            gallery:{
                enabled:true
            }
        });
    }

    if ($('body#hero-is-video').length > 0) {
        const element = $('.hero-section');  //record the elem so you don't crawl the DOM everytime
        const bottom = element.position().top + element.outerHeight(true);

        $(window).scroll(function() {
            const windowPosition = $(window).scrollTop();
            if (windowPosition  > bottom) {
                $('#hero-is-video .header-nav').addClass('fixed-video-nav');
                $('#hero-is-video .header-nav .logo-standard').show();
                $('#hero-is-video .header-nav .logo-white').hide();
            } else {
                $('#hero-is-video .header-nav').removeClass('fixed-video-nav');
                $('#hero-is-video .header-nav .logo-standard').hide();
                $('#hero-is-video .header-nav .logo-white').show();
            }
        });
    }

    if ($('.custom-flexible-section').hasClass('map-section')) {
        const google = window.google;
        const mapLng = $('.map-section').data('lng');
        const mapLat = $('.map-section').data('lat');
        const mapZoom = $('.map-section').data('zoom');

        const mapCenter = { lat: mapLat, lng: mapLng };
        const map = new google.maps.Map(document.getElementById('map'), {
            zoom: mapZoom,
            center: mapCenter,
            scrollWheel: false,
            streetViewControl: false,
        });
        new google.maps.Marker({
            position: mapCenter,
            map,
            icon: 'https://d1ssu070pg2v9i.cloudfront.net/pex/lovedougalston/2020/11/16115750/map-marker.png',
        });
    }
};

export default common;
