<?php
$title = get_sub_field('title');
$description = get_sub_field('description');
$teamMembers = get_sub_field('team_members');
$defaultTeamImage = get_template_directory_uri() . '/dist/images/default-team.png';
if($teamMembers) { ?>
    <div class="custom-flexible-section team-section">
        <div class="container">
            <?php if($title) { ?><h2><?= $title; ?></h2><?php } ?>
            <?php if($description) { ?><div class="description"><?= $description; ?></div><?php } ?>
            <div class="team-members">
                <div class="row">
                    <?php foreach($teamMembers as $member) {
                        $image = $member['image'] ? $member['image']['url'] : $defaultTeamImage;
                        ?>
                        <div class="col-lg-6 team-col">
                            <div class="inner-team-member">
                                <div class="image-holder">
                                    <img src="<?= $image; ?>" alt="<?= $member['name']; ?>">
                                </div>
                                <div class="info-holder">
                                    <div class="name"><?= $member['name']; ?></div>
                                    <div class="description"><?= $member['description']; ?></div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
<?php } ?>