<?php
$blocks = get_sub_field('blocks');
$companyLogo = get_field('company_logo', 'option');
if($blocks) {

    $title = get_sub_field('title');
    $description = get_sub_field('introduction');

    ?>
    <div class="custom-flexible-section block-section">
        <div class="container">

            <?php if($title) { ?><h2><?= $title; ?></h2><?php } ?>
            <?php if($description) { ?><div class="introduction"><?= $description; ?></div><?php } ?>

            <div class="row row-eq-height">
                <?php foreach($blocks as $block) {
                    $image = $block['image']['url'] ?: $companyLogo['url'];
                    $imageClass = $block['image'] ? 'set-image' : 'default-image'; ?>
                    <div class="col-lg-4 block-col d-flex">
                        <div class="inner-block">
                            <div class="image-holder <?= $imageClass; ?>">
                                <img src="<?= $image; ?>">
                                <?php if($block['image']) { ?><img class="bottom-svg" src="<?= get_template_directory_uri() . '/dist/images/image-textures/bottom-layer-2.svg' ?>" alt=""><?php } ?>
                            </div>
                            <div class="info-holder">
                                <h3><?= $block['title']; ?></h3>
                                <div class="description"><?= $block['description']; ?></div>
                                <div class="cta-section">
                                    <?php
                                    if($block['cta'] == 'cta') { ?>
                                        <a href="<?= $block['custom_cta']['url']; ?>" class="cta"><?= $block['custom_cta']['title']; ?></a>
                                    <?php } elseif($block['cta'] == 'email') {
                                        $email = get_field('contact_email_address', 'option');
                                        ?>
                                        <a href="<?= 'mailto:' . $email; ?>" class="email"><?= $email; ?></a>
                                    <?php } else {
                                        if (have_rows('social_media_channels', 'option')) { ?>
                                            <div class="socials">
                                                <ul>
                                                    <?php while (have_rows('social_media_channels', 'option')) {
                                                        the_row(); ?>
                                                        <li>
                                                            <a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener">
                                                                <span class="fa-stack fa-2x">
                                                                  <i class="fal fa-circle fa-stack-2x"></i>
                                                                  <i class="<?php the_sub_field('fa5_icon_class'); ?> fa-stack-1x fa-inverse social-icon"></i>
                                                                </span>
                                                            </a>
                                                        </li>
                                                    <?php } ?>
                                                </ul>
                                            </div>
                                        <?php }
                                    } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
