<?php
$companyLogo = get_field('company_logo', 'option');
$companyLogoWhite = get_field('company_logo_white', 'option');
?>

<nav class="header-nav">
    <div class="container custom-head-container">
        <a class="navbar-brand" href="<?= esc_url(home_url('/')); ?>">
            <img src="<?= $companyLogo['url']; ?>" alt="<?php bloginfo('name'); ?>" class="logo-standard" />
            <img src="<?= $companyLogoWhite['url']; ?>" alt="<?php bloginfo('name'); ?>" class="logo-white" />
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <i class="fal fa-bars fa-2x"></i>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <?php
            if (has_nav_menu('main_menu')) {
                wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation']);
            }
            if (have_rows('social_media_channels', 'option')) { ?>
                <div class="socials">
                    <ul>
                        <?php while (have_rows('social_media_channels', 'option')) {
                            the_row(); ?>
                            <li>
                                <a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener">
                                        <span class="fa-stack fa-2x">
                                          <i class="fal fa-circle fa-stack-2x"></i>
                                          <i class="<?php the_sub_field('fa5_icon_class'); ?> fa-stack-1x fa-inverse social-icon"></i>
                                        </span>
                                </a>
                            </li>
                        <?php } ?>
                    </ul>
                </div>
            <?php } ?>
        </div>
    </div>
</nav>
