<?php
namespace Blue2\Scruffy;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu'
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        // Empty
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
    }

    private function setupControllers(){
        //Empty
    }

    public function registerPostTypes()
    {

    }

    public static function outputGalleryGrid($images)
    {
        if ($images) { ?>
            <div class="grid-gallery">
                <div class="grid-sizer"></div>
                <div class="gutter-sizer"></div>
                <?php foreach ($images as $key => $image) {
                    $imageURL = $image['url'];
                    $imageWidth = $image['width'];
                    $imageHeight = $image['height'];
                    $imageCaption = $image['alt'];
                    ?>
                    <div class="grid-item" data-index="<?= $key ?>" style=" height: 240px;">
                        <img data-src="<?= $imageURL ?>" data-fullsrc="<?= $imageURL ?>"
                             data-fullwidth="<?= $imageWidth ?>" data-fullheight="<?= $imageHeight ?>"
                             alt="<?= $imageCaption ?>" data-caption="<?= $imageCaption ?>" class="img-fluid lazy">
                    </div>
                <?php } ?>
            </div>
        <?php } else { ?>
            <p class="text-center"><strong>There were no images added</strong></p>
        <?php };
    }

}
