<?php
$form = get_sub_field('contact_form_shortcode');
$companyLocation = get_field('company_location', 'option');
$address = get_sub_field('address') ?: $companyLocation['address'];
$telephone = get_field('contact_phone_number', 'option');
$email = get_field('contact_email_address', 'option');
$fax = get_field('contact_fax_number', 'option');
$callMessage = get_sub_field('call_message'); ?>
<div class="flexible-section contact-section">
    <div class="container">
        <div class="row row-eq-height">
            <div class="col-lg-6">
                <h1><?php the_sub_field('contact_form_title'); ?></h1>
                <?php if($form) { echo do_shortcode($form); } ?>
            </div>
            <div class="col-lg-6">
                <div id="map" data-lat="<?= $companyLocation['lat'] ?>" data-lng="<?= $companyLocation['lng']; ?>" data-zoom="<?= $companyLocation['zoom']; ?>" data-address="<?= $address; ?>"></div>
            </div>
            <div class="offset-lg-6 col">
                <div class="address"><?= $address ?></div>
                <ul class="contact-list">
                    <?php if($telephone) { ?><li><i class="fas fa-phone"></i> <a href="tel:<?= $telephone; ?>"><?= $telephone; ?></a></li><?php } ?>
                    <?php if($fax) { ?><li><i class="fal fa-fax"></i> <a href="tel:<?= $fax; ?>"><?= $fax; ?></a></li><?php } ?>
                    <?php if($email) { ?><li class="email"><i class="far fa-envelope"></i> <a href="mailto:<?= $email; ?>"><?= $email; ?></a></li><?php } ?>
                </ul>
                <?php if($callMessage) { ?><div class="call-message"><?= $callMessage; ?></div><?php } ?>
            </div>
        </div>
    </div>
</div>
