<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
$enquire_needed = false;

if ($product->get_shipping_class() == 'enquire-needed') {
    echo
        "<style> .single_add_to_cart_button, .qty   {
            display: none !important;       
        }
        </style>";
    $enquire_needed = true;
}

?>
<div class="custom-single-product">

    <div class="container">
        <?php
        /**
         * Hook: woocommerce_before_single_product.
         *
         * @hooked woocommerce_output_all_notices - 10
         */
        do_action( 'woocommerce_before_single_product' ); ?>

        <?php if ( function_exists('yoast_breadcrumb') ) {
            yoast_breadcrumb( '<div class="custom-breadcrumbs"><p id="breadcrumbs">','</p></div>' );
        } ?>

    </div>
    <?php
    if ( post_password_required() ) {
        echo get_the_password_form(); // WPCS: XSS ok.
        return;
    }
    ?>
    <div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
        <?php
        $category = get_the_terms(get_the_id(), 'product_cat');
        $brand = get_the_terms(get_the_id(), 'brand');
        if($category) {?>
            <div class="category-banner">
                <div class="container">
                    <div class="category-inner">
                        <h2><?= $brand[0]->name . ' ' . $category[0]->name; ?></h2>
                        <div class="view-all"><a href="<?= '/brand/' . $brand[0]->slug . '/'; ?>">View all <?= $brand[0]->name; ?></a></div>
                    </div>
                </div>
            </div>
        <?php } ?>


        <div class="container">
            <div class="product-top-section">
                <div class="row">
                    <div class="order-lg-2 col-lg-6">
                        <?php
                        /**
                         * Hook: woocommerce_before_single_product_summary.
                         *
                         * @hooked woocommerce_show_product_sale_flash - 10
                         * @hooked woocommerce_show_product_images - 20
                         */
                        do_action( 'woocommerce_before_single_product_summary' );
                        ?>
                    </div>
                    <div class="order-lg-1 col-lg-6">
                        <div class="summary entry-summary">
                            <?php
                            /**
                             * Hook: woocommerce_single_product_summary.
                             *
                             * @hooked woocommerce_template_single_title - 5
                             * @hooked woocommerce_template_single_rating - 10
                             * @hooked woocommerce_template_single_price - 10
                             * @hooked woocommerce_template_single_excerpt - 20
                             * @hooked woocommerce_template_single_add_to_cart - 30
                             * @hooked woocommerce_template_single_meta - 40
                             * @hooked woocommerce_template_single_sharing - 50
                             * @hooked WC_Structured_Data::generate_product_data() - 60
                             */
                            do_action( 'woocommerce_single_product_summary' );
                            ?>
                            <?php if (!$product->is_in_stock()) { ?>
                                <a href="" id="trigger-stock-notification" data-toggle="modal" data-target="#stockNotifyModal" data-title="<?php the_title(); ?>">Click here to be notified when this product is back in stock</a>
                                <?php get_template_part('templates/sections/modals/stock-notify-modal'); ?>
                            <?php } ?>



                            <?php if(get_field('below_price_output_message')) { ?>
                                <div class="below-price-output">
                                    <?php the_field('below_price_output_message'); ?>
                                </div>
                            <?php } ?>


                            <?php if($enquire_needed) { ?>
                                <div class="below-price-output">
                                    <p class="text-left"><b>Online ordering for this item is unavailable, please <a href="/?page_id=100&prod_name=<?= $product->get_name() ?>&message=<?=  get_field('enquiry_mail_template', 'option') ?>">click here</a> to enquire or call us on <a href="tel:01307468556">01307 468556</a> for advice on delivery and payment options.</b></p>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>

            <hr/>

            <?php $productFeatures = get_field('product_features');
            if($productFeatures) { ?>
                <div class="feature-section">
                    <h2>Features</h2>
                    <div class="row">
                        <?php foreach($productFeatures as $feature) { ?>
                            <div class="col-lg-6 feature-col">
                                <h3><?= $feature['feature_title']; ?></h3>
                                <div class="description"><?= $feature['feature_description']; ?></div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
        </div>

        <?php
        $relatedIDs = get_field('related_product_overrides') ?: wc_get_related_products(get_the_id());
        if($relatedIDs){
            $companyLogoAlt = get_field('alternate_company_logo', 'option'); ?>
            <div class="related-product-section">
                <div class="container">
                    <h2>Related Products</h2>
                    <div class="swiper-container related-products">
                        <div class="swiper-wrapper">
                            <?php foreach($relatedIDs as $id) {
                                $product = wc_get_product($id);
                                $image = get_the_post_thumbnail_url($id, 'product-card-image') ?: $companyLogoAlt['url'];
                                $imageClass = get_the_post_thumbnail_url($id) ? 'featured-image' : 'default-image';
                                $saleClass = $product->get_sale_price() ? 'sale-active' : 'sale-inactive';
                                $vatMessage = get_option('woocommerce_price_display_suffix') ? ' <span class="vat-suffix">' . get_option('woocommerce_price_display_suffix') . '</span>' : "";
                                ?>
                                <div class="swiper-slide">
                                    <div class="product-item">
                                        <a href="<?= get_permalink( $product->get_id() ); ?>">
                                            <div class="image-holder <?= $imageClass; ?>"><img src="<?= $image; ?>" alt="<?php the_title(); ?>"></div>
                                            <h2 title="<?= $product->get_name(); ?>"><?= $product->get_name(); ?></h2>
                                            <div class="bottom-holder">
                                                <div class="price-holder <?= $saleClass; ?>">
                                                    <div class="price rrp <?= $saleClass; ?>"><span class="amount"><?= get_woocommerce_currency_symbol() . $product->get_regular_price() . '</span> <span class="price-suffix">RRP</span>' . $vatMessage; ?></div>
                                                    <?php if($product->get_sale_price()) { ?><div class="price sale"><?= get_woocommerce_currency_symbol() . $product->get_sale_price() . ' <span class="price-suffix">Our Price</span>' . $vatMessage; ?></div><?php } ?>
                                                </div>
                                                <?php if (!$product->is_in_stock()) { ?>
                                                    <span class="stock-message">Out of stock</span>
                                                <?php } ?>
                                            </div>
                                            <span class="product-overlay">
                                                  <div class="product-page-box">Go to product page</div>
                                            </span>
                                        </a>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php }
        $featuredProduct = get_field('featured_product');
        if($featuredProduct) {
            $product = wc_get_product($featuredProduct->ID);
            $smallTitle = 'Featured Product';
            $largeTitle = get_the_title($featuredProduct->ID);
            $description = get_post_field('post_content', $featuredProduct);
            $ctaText = 'Find out more';
            $ctaURL = get_the_permalink($featuredProduct->ID);
            $price = get_woocommerce_currency_symbol() . $product->get_price();
            $preTitle = get_field('product_banner_pre-text', $featuredProduct->ID);
            $bannerImage = get_field('product_banner_background_image', $featuredProduct->ID); ?>
            <div class="flexible-section banner-section" style="background-image:url('<?= $bannerImage['url']; ?>')">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-8 col-xl-7">
                            <h5 class="small-title"><?= $smallTitle; ?></h5>
                            <div class="pre-text"><?= $preTitle; ?></div>
                            <h2 class="large-title"><?= $largeTitle; ?></h2>
                            <div class="description"><?= $description; ?></div>
                            <div class="bottom">
                                <div class="price"><?= $price; ?></div>
                                <a href="<?= $ctaURL ?>"><?= $ctaText; ?> <i class="far fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <?php do_action( 'woocommerce_after_single_product' ); ?>
</div>
