<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\ProductController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_theme_support('woocommerce');
        add_theme_support('post-thumbnails');
        add_theme_support('woocommerce');
        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_products_menu' => 'Footer Products Menu',
            'footer_services_menu' => 'Footer Services Menu',
            'footer_company_menu' => 'Footer Company Menu',
            'footer_customer_service_menu' => 'Footer Customer Service Menu',
            'footer_documentation_menu' => 'Footer Documentation Menu',
        ]);
    }

    public function tidyExcerpt()
    {
        return '...';
    }

    private function registerShortCodes()
    {
        add_shortcode( 'careerTitle', [$this, 'careerTitleShortcode'] );
    }

    private function registerFilters(){
        add_filter('acf/fields/google_map/api', [$this, 'myAcfGoogleMapApi']);
        add_filter('wp_enqueue_scripts', [$this, 'enqueueScripts']);
        add_filter('walker_nav_menu_start_el', [$this, 'addChevronToMenuItemsWithChildren'], 10, 4 );
        add_filter('script_loader_tag', [$this, 'addIDtoZendeskScript'], 10, 3 );
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('init', [$this, 'customOptionsPages']);
        add_action('init', [$this, 'customImageSizes']);
        add_action('wp_enqueue_scripts', [$this, 'enqueueZendeskScript']);
    }

    private function setupControllers(){
        new ProductController();
    }

    public function registerPostTypes(){
        Post\Career::registerPostType();
        Post\Testimonial::registerPostType();
    }

    public function customImageSizes()
    {
        add_image_size('product-card-image', 0, 265, false);
    }

    public function enqueueScripts()
    {
        $layouts = get_post_meta(get_the_id(), 'flexible_sections', true);
        if (is_array($layouts) && in_array('contact_section', $layouts)) {
            wp_enqueue_script('google-maps', '//maps.googleapis.com/maps/api/js?key=AIzaSyCqF8Zo89zCj3kzStNPcfuqZBAnhW8Dmwo', ['jquery'], null, true);
            wp_register_script("contact-hidden", get_bloginfo('template_url') . '/assets/scripts/contact.js');
            wp_enqueue_script('contact-hidden');
        }
    }

    public function myAcfGoogleMapApi($api)
    {
        $api['key'] = 'AIzaSyCqF8Zo89zCj3kzStNPcfuqZBAnhW8Dmwo';
        return $api;
    }

    public function customOptionsPages()
    {
        if (function_exists('acf_add_options_page')) {
            acf_add_options_page([
                'title' => 'Product Settings',
                'parent' => 'edit.php?post_type=product',
                'capability' => 'edit_posts',
            ]);
            acf_add_options_page([
                'title' => 'Career Settings',
                'parent' => 'edit.php?post_type=career',
                'capability' => 'edit_posts',
            ]);
        }
    }

    public function addChevronToMenuItemsWithChildren( $item_output, $item, $depth, $args ) {
        if ( $args->theme_location == 'main_menu' && $args->menu_class == 'navigation') {
            if ( in_array( 'menu-item-has-children', $item->classes ) || in_array( 'page_item_has_children', $item->classes ) ) {
                $item_output = str_replace( $args->link_after . '</a>', $args->link_after . '<i class="fas fa-chevron-down main-menu-chevron"></i>', $item_output );
            }
        }
        return $item_output;
    }

    public function careerTitleShortcode($atts) {
        return get_the_title();
    }

    public function enqueueZendeskScript() {
        $enableZendesk = get_field('enable_zendesk', 'option');
        if($enableZendesk) {
            wp_enqueue_script('ze-snippet', '//static.zdassets.com/ekr/snippet.js?key=ba97044d-667d-4322-ab2f-89ca94da0632', [], null, true);
        }
    }

    public function addIDtoZendeskScript( $tag, $handle, $source ) {
        if ( 'ze-snippet' === $handle ) {
            $tag = '<script defer type="text/javascript" src="' . $source . '" id="ze-snippet"></script>';
        }
        return $tag;
    }

}
