<?php
get_header();
$companyLogoAlt = get_field('alternate_company_logo', 'option');
?>
<div class="custom-search-results">
    <div class="container">
        <h1 class="page-title"><?php printf( __( 'Search Results for: %s', 'shape' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
        <?php if ( have_posts() ) { ?>
            <div class="search-output">
                <div class="row row-eq-height">

                    <?php while (have_posts()) {
                        the_post();
                        $image = get_the_post_thumbnail_url(get_the_id(), 'thumbnail') ?: $companyLogoAlt['url'];
                        $imageClass = get_the_post_thumbnail_url(get_the_id()) ? 'featured-image' : 'default-image';
                        ?>
                        <div class="col-lg-6 search-col">
                            <div class="search-result">
                                <a href="<?php the_permalink(); ?>">
                                    <div class="row">
                                        <div class="col-4">
                                            <div class="image-section <?= $imageClass; ?>">
                                                <img src="<?= $image; ?>" alt="<?php the_title(); ?>">
                                            </div>
                                        </div>
                                        <div class="col-8">
                                            <div class="content-section">
                                                <h2><?php the_title(); ?></h2>
                                                <div class="description">
                                                    <?= substr(get_the_excerpt(), 0, 150) . '...'; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                </a>
                            </div>
                        </div>

                    <?php } ?>
                </div>
            </div>
            <div class="custom-pagination search-pagination">
                <?php
                the_posts_pagination([
                    'mid_size' => 1,
                    'prev_text' => __('Previous', 'textdomain'),
                    'next_text' => __('Next', 'textdomain'),
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
                ]); ?>
            </div>
        <?php } else { ?>
            <div class="search-output no-results">
                <div class="row row-eq-height">
                    <div class="col-12">
                        <div class="no-results-found">No results have been found which match your search criteria.</div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
</div>
<?php get_footer(); ?>
