<?php
$bannerType = get_sub_field('banner_type');
if($bannerType == 'featured-product') {
    $featuredProduct = get_sub_field('featured_product');
    $product = wc_get_product($featuredProduct->ID);
    $smallTitle = 'Featured Product';
    $largeTitle = get_the_title($featuredProduct->ID);
    $description = get_post_field('post_content', $featuredProduct);
    $ctaText = 'Find out more';
    $ctaURL = get_the_permalink($featuredProduct->ID);
    if ($product) {
        $price = $product->get_sale_price() ? wc_get_price_to_display( $product, ['price' => $product->get_sale_price()]) : wc_get_price_to_display( $product, ['price' => $product->get_regular_price()]);
        $vatMessage = get_option('woocommerce_price_display_suffix') ? ' <span class="vat-suffix">' . get_option('woocommerce_price_display_suffix') . '</span>' : "";
    }
    $preTitle = get_field('product_banner_pre-text', $featuredProduct->ID);
    $bannerImage = get_field('product_banner_background_image', $featuredProduct->ID);
} else {
    $smallTitle = get_sub_field('custom_small_title');
    $largeTitle = get_sub_field('custom_large_title');
    $description = get_sub_field('custom_description');
    $ctaText = get_sub_field('custom_cta')['title'];
    $ctaURL = get_sub_field('custom_cta')['url'];
    $bannerImage = get_sub_field('custom_image');
}
?>
<div class="flexible-section banner-section" style="background-image:url('<?= $bannerImage['url']; ?>')">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 col-xl-7">
                <h5 class="small-title"><?= $smallTitle; ?></h5>
                <?php if($bannerType == 'featured-product' && $preTitle) { ?><div class="pre-text"><?= $preTitle; ?></div><?php } ?>
                <h2 class="large-title"><?= $largeTitle; ?></h2>
                <div class="description"><?= $description; ?></div>
                <div class="bottom">
                    <?php if($bannerType == 'featured-product' && $price) { ?><div class="price"><?= get_woocommerce_currency_symbol() . number_format($price, 2) . $vatMessage; ?></div><?php } ?>
                    <a href="<?= $ctaURL ?>"><?= $ctaText; ?> <i class="far fa-arrow-right"></i></a>
                </div>
            </div>
        </div>
    </div>
</div>
