<?php
$title = get_sub_field('category_section_title');
$categories = get_sub_field('categories');
$altCompanyLogo = get_field('alternate_company_logo', 'option');
if($categories) {?>
    <div class="flexible-section product-category-section">
        <div class="container">
            <?php if($title) { ?><h2><?= $title; ?></h2><?php } ?>
            <div class="category-output">
                <div class="row row-eq-height">
                    <?php foreach($categories as $category) {
                        $thumbnailID = get_term_meta( $category->term_id, 'thumbnail_id', true );
                        $image = wp_get_attachment_url( $thumbnailID ) ?: $altCompanyLogo['url']; ?>
                        <div class="category-col col-md-6 col-xl-4">
                            <div class="category-item">
                                <a href="<?= get_category_link($category->term_id); ?>">
                                    <div class="image-holder"><img src="<?= $image; ?>" alt="<?= $category->name; ?>"></div>
                                    <div class="name"><div class="text"><?= $category->name; ?></div><div class="arrow"><i class="far fa-long-arrow-right"></i></div></div>
                                </a>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
