const common = () => {
    if ($('#map').length) {
        const google = window.google;
        const mapLng = $('#map')
            .data('lng');
        const mapLat = $('#map')
            .data('lat');
        const mapZoom = $('#map')
            .data('zoom');
        const mapCenter = { lat: mapLat, lng: mapLng };
        const map = new google.maps.Map(document.getElementById('map'), {
            zoom: mapZoom,
            center: mapCenter,
            scrollWheel: false,
            streetViewControl: false,
        });
        new google.maps.Marker({
            position: mapCenter,
            map,
        });
    }

    $('.search.right-item').on('click', () => {
        $('.custom-search-form').addClass('active');
        $('.custom-search-form').delay(300)
            .fadeIn(function() {
                $('.right-section').css('overflow', 'visible');
                $(this).find('.search-field')
                    .focus();
            });
    });

    $('.search-field').on('focusout', () => {
        $('.right-section').css('overflow', 'hidden');
        $('.custom-search-form').removeClass('active');
    });

    $('.mobile-toggle').on('click', () => {
        $('svg.mobile-nav').toggleClass('fa-times fa-bars');
        $('.mobile-navigation').slideToggle();
    });

    if ($('.active-trigger').length) {
        $('.active-trigger').on('click', function(e) {
            const title = $(this).data('title');
            const description = $(this).data('description');
            const taxonomy = $(this).data('taxonomy');
            const term = $(this).attr('id');
            e.preventDefault();

            $('.overlay-expanded').addClass('active');
            $('.flexible-layout-sections').addClass('overlay-active');
            $('.overlay-expanded .top .title').text(title);
            $('.overlay-expanded .description').text(description);

            const categoryItems = $('.category-overlay-item a');
            let updatedURL;

            for (let i = 0; i < categoryItems.length; i++) {
                const urlLinks = $(categoryItems[i]).attr('href');
                if (taxonomy === 'condition') {
                    if (urlLinks.indexOf('brand=') >= 0) {
                        updatedURL = urlLinks.split('brand=')[0];
                    } else {
                        updatedURL = urlLinks.split('condition=')[0];
                    }
                    updatedURL += `condition=${term}`;
                    $(categoryItems[i]).prop('href', updatedURL);
                } else {
                    if (urlLinks.indexOf('condition=') >= 0) {
                        updatedURL = urlLinks.split('condition=')[0];
                    } else {
                        updatedURL = urlLinks.split('brand=')[0];
                    }
                    updatedURL += `brand=${term}`;
                    $(categoryItems[i]).prop('href', updatedURL);
                }
            }
        });
    }

    $(document).on('click', '.close-overlay', () => {
        $('.overlay-expanded').removeClass('active');
        $('.flexible-layout-sections').removeClass('overlay-active');
    });

    $('.play-video').on('click', () => {
        const video = $('#hero-video');
        video.paused ? video.trigger('play') : video.trigger('pause');
    });

    let playing = false;
    $('.play-video').click(() => {
        $('.play-video svg').toggleClass('fa-play-circle fa-pause-circle');
        if (playing === false) {
            $('#hero-video').trigger('play');
            playing = true;
            $('.button-text').text('Pause video');
        } else {
            $('#hero-video').trigger('pause');
            playing = false;
            $('.button-text').text('Watch this video');
        }
    });
};

export default common;
